/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Member
extends InstanceResource {
    private static final String URL = "Url";
    private static final String METHOD = "Method";
    private static final String QUEUE_SID = "queue_sid";
    private static final String CALL_SID = "call_sid";
    private static final String DATE_ENQUEUED = "date_enqueued";
    private static final String WAIT_TIME = "wait_time";
    private static final String POSITION = "position";
    static final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
    public static final String QUEUE_FRONT = "Front";

    public Member(TwilioRestClient client, String queueSid, String callSid) {
        super(client);
        this.setProperty(QUEUE_SID, queueSid);
        this.setProperty(CALL_SID, callSid);
    }

    public Member(TwilioRestClient client, String queueSid) {
        this(client, queueSid, QUEUE_FRONT);
    }

    public Member(TwilioRestClient client, Map<String, Object> properties, String queueSid) {
        super(client, properties);
        this.setProperty(QUEUE_SID, queueSid);
    }

    public String getQueueSid() {
        return this.getProperty(QUEUE_SID);
    }

    public String getCallSid() {
        return this.getProperty(CALL_SID);
    }

    public Date getDateEnqueued() {
        try {
            return format.parse(this.getProperty(DATE_ENQUEUED));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getWaitTime() {
        return this.getProperty(WAIT_TIME);
    }

    public String getPosition() {
        return this.getProperty(POSITION);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Queues/" + this.getQueueSid() + "/Members/" + this.getCallSid() + ".json";
    }

    public Member dequeue(String url, String method) throws TwilioRestException {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put(URL, url);
        vars.put(METHOD, method);
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", vars);
        Member member = new Member(this.getClient(), response.toMap(), this.getQueueSid());
        member.setRequestAccountSid(this.getRequestAccountSid());
        return member;
    }
}

