/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.sip;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.ListResource;
import com.twilio.sdk.resource.factory.sip.CredentialListMappingFactory;
import com.twilio.sdk.resource.instance.sip.CredentialListMapping;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class CredentialListMappingList
extends ListResource<CredentialListMapping>
implements CredentialListMappingFactory {
    private String requestSipDomainSid;

    public CredentialListMappingList(TwilioRestClient client) {
        super(client);
    }

    public CredentialListMappingList(TwilioRestClient client, String sipDomainSid) {
        super(client);
        this.requestSipDomainSid = sipDomainSid;
    }

    public CredentialListMappingList(TwilioRestClient client, Map<String, String> filters) {
        super(client, filters);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/SIP/Domains/" + this.getRequestSipDomainSid() + "/CredentialListMappings.json";
    }

    @Override
    protected CredentialListMapping makeNew(TwilioRestClient client, Map<String, Object> params) {
        return new CredentialListMapping(client, params);
    }

    @Override
    protected String getListKey() {
        return "credential_list_mappings";
    }

    @Override
    public CredentialListMapping create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew(this.getClient(), (Map)response.toMap());
    }

    @Override
    public CredentialListMapping create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = this.getClient().safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew(this.getClient(), (Map)response.toMap());
    }

    public String getRequestSipDomainSid() {
        return this.requestSipDomainSid;
    }
}

