/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.AppEngineClientConnectionManager;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public abstract class TwilioClient {
    private static final int ACCOUNT_SID_LENGTH = 34;
    private static final int AUTH_TOKEN_LENGTH = 32;
    private static final String VERSION = "4.4.1";
    private String endpoint = "https://api.twilio.com";
    public static final String DEFAULT_VERSION = "2010-04-01";
    private final String accountSid;
    private final String authToken;
    private int numRetries = 3;
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 30500;
    private HttpClient httpclient;

    public int getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(int numRetries) {
        this.numRetries = numRetries;
    }

    public void setHttpClient(HttpClient httpclient) {
        this.httpclient = httpclient;
    }

    public HttpClient getHttpClient() {
        return this.httpclient;
    }

    public TwilioClient(String accountSid, String authToken) {
        this(accountSid, authToken, null);
    }

    public TwilioClient(String accountSid, String authToken, String endpoint) {
        Object mgr;
        this.validateAccountSid(accountSid);
        this.validateAuthToken(authToken);
        this.accountSid = accountSid;
        this.authToken = authToken;
        if (endpoint != null && !endpoint.equals("")) {
            this.endpoint = endpoint;
        }
        try {
            Class.forName("com.google.appengine.api.urlfetch.HTTPRequest");
            mgr = new AppEngineClientConnectionManager();
        }
        catch (ClassNotFoundException e) {
            mgr = new PoolingClientConnectionManager();
            mgr.setDefaultMaxPerRoute(10);
        }
        this.setHttpClient((HttpClient)new DefaultHttpClient((ClientConnectionManager)mgr));
        this.httpclient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        this.httpclient.getParams().setParameter("http.socket.timeout", (Object)new Integer(30500));
        this.httpclient.getParams().setParameter("http.connection.timeout", (Object)new Integer(10000));
        this.httpclient.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
    }

    private void validateAuthToken(String authToken) {
        if (authToken == null || authToken.length() != 32) {
            throw new IllegalArgumentException("AuthToken '" + authToken + "' is not valid.");
        }
    }

    private void validateAccountSid(String accountSid) {
        if (accountSid == null || !accountSid.startsWith("AC") || accountSid.length() != 34) {
            throw new IllegalArgumentException("AccountSid '" + accountSid + "' is not valid.  It should be the 34 character unique identifier starting with 'AC'");
        }
    }

    private static List<NameValuePair> generateParameters(Map<String, String> vars) {
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        if (vars != null) {
            for (String var : vars.keySet()) {
                qparams.add((NameValuePair)new BasicNameValuePair(var, vars.get(var)));
            }
        }
        return qparams;
    }

    private HttpUriRequest buildMethod(String method, String path, List<NameValuePair> params) {
        if (method.equalsIgnoreCase("GET")) {
            return this.generateGetRequest(path, params);
        }
        if (method.equalsIgnoreCase("POST")) {
            return this.generatePostRequest(path, params);
        }
        if (method.equalsIgnoreCase("PUT")) {
            return this.generatePutRequest(path, params);
        }
        if (method.equalsIgnoreCase("DELETE")) {
            return this.generateDeleteRequest(path, params);
        }
        throw new IllegalArgumentException("Unknown Method: " + method);
    }

    private HttpGet generateGetRequest(String path, List<NameValuePair> params) {
        URI uri = this.buildUri(path, params);
        return new HttpGet(uri);
    }

    private HttpPost generatePostRequest(String path, List<NameValuePair> params) {
        URI uri = this.buildUri(path);
        UrlEncodedFormEntity entity = this.buildEntityBody(params);
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    private HttpPut generatePutRequest(String path, List<NameValuePair> params) {
        URI uri = this.buildUri(path);
        UrlEncodedFormEntity entity = this.buildEntityBody(params);
        HttpPut put = new HttpPut(uri);
        put.setEntity((HttpEntity)entity);
        return put;
    }

    private HttpDelete generateDeleteRequest(String path, List<NameValuePair> params) {
        URI uri = this.buildUri(path);
        return new HttpDelete(uri);
    }

    private UrlEncodedFormEntity buildEntityBody(List<NameValuePair> params) {
        UrlEncodedFormEntity entity;
        try {
            entity = new UrlEncodedFormEntity(params, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return entity;
    }

    private URI buildUri(String path) {
        return this.buildUri(path, null);
    }

    private URI buildUri(String path, List<NameValuePair> queryStringParams) {
        URI uri;
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (queryStringParams != null && queryStringParams.size() > 0) {
            sb.append("?");
            sb.append(URLEncodedUtils.format(queryStringParams, (String)"UTF-8"));
        }
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid uri", e);
        }
        return uri;
    }

    public TwilioRestResponse request(String path, String method, Map<String, String> paramMap) throws TwilioRestException {
        List<NameValuePair> paramList = TwilioClient.generateParameters(paramMap);
        return this.request(path, method, paramList);
    }

    public TwilioRestResponse request(String path, String method, List<NameValuePair> paramList) throws TwilioRestException {
        HttpUriRequest request = this.setupRequest(path, method, paramList);
        try {
            HttpResponse response = this.httpclient.execute(request);
            HttpEntity entity = response.getEntity();
            Header[] contentTypeHeaders = response.getHeaders("Content-Type");
            String responseBody = "";
            if (entity != null) {
                responseBody = EntityUtils.toString((HttpEntity)entity);
            }
            StatusLine status = response.getStatusLine();
            int statusCode = status.getStatusCode();
            TwilioRestResponse restResponse = new TwilioRestResponse(request.getURI().toString(), responseBody, statusCode);
            int i$ = 0;
            Header[] arr$ = contentTypeHeaders;
            int len$ = arr$.length;
            if (i$ < len$) {
                Header h = arr$[i$];
                restResponse.setContentType(h.getValue());
            }
            return restResponse;
        }
        catch (ClientProtocolException e1) {
            throw new RuntimeException(e1);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    public InputStream requestStream(String path, String method, Map<String, String> vars) {
        List<NameValuePair> paramList = TwilioClient.generateParameters(vars);
        return this.requestStream(path, method, paramList);
    }

    public InputStream requestStream(String path, String method, List<NameValuePair> paramList) {
        HttpUriRequest request = this.setupRequest(path, method, paramList);
        try {
            HttpResponse response = this.httpclient.execute(request);
            HttpEntity entity = response.getEntity();
            return entity.getContent();
        }
        catch (ClientProtocolException e1) {
            throw new RuntimeException(e1);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    private HttpUriRequest setupRequest(String path, String method, List<NameValuePair> params) {
        String normalizedPath = path.toLowerCase();
        StringBuilder sb = new StringBuilder();
        if (normalizedPath.startsWith("http://") || normalizedPath.startsWith("https://")) {
            sb.append(path);
        } else {
            sb.append(this.getEndpoint());
            if (!normalizedPath.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
        }
        path = sb.toString();
        HttpUriRequest request = this.buildMethod(method, path, params);
        request.addHeader((Header)new BasicHeader("X-Twilio-Client", "java-4.4.1"));
        request.addHeader((Header)new BasicHeader("User-Agent", "twilio-java/4.4.1"));
        request.addHeader((Header)new BasicHeader("Accept", "application/json"));
        request.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
        if (this.httpclient instanceof DefaultHttpClient) {
            ((DefaultHttpClient)this.httpclient).getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.accountSid, this.authToken));
        }
        return request;
    }

    public TwilioRestResponse safeRequest(String path, String method, Map<String, String> vars) throws TwilioRestException {
        List<NameValuePair> paramList = TwilioClient.generateParameters(vars);
        return this.safeRequest(path, method, paramList);
    }

    public TwilioRestResponse safeRequest(String path, String method, List<NameValuePair> paramList) throws TwilioRestException {
        TwilioRestResponse response = null;
        for (int retry = 0; retry < this.numRetries; ++retry) {
            response = this.request(path, method, paramList);
            if (response.isClientError()) {
                throw TwilioRestException.parseResponse(response);
            }
            if (response.isServerError()) {
                try {
                    Thread.sleep(100 * retry);
                }
                catch (InterruptedException e) {}
                continue;
            }
            return response;
        }
        int errorCode = response == null ? -1 : response.getHttpStatus();
        throw new TwilioRestException("Cannot fetch: " + method + " " + path, errorCode);
    }

    public TwilioRestResponse get(String fullUri) throws TwilioRestException {
        TwilioRestResponse response = null;
        for (int retry = 0; retry < this.numRetries; ++retry) {
            response = this.request(fullUri, "GET", (Map<String, String>)null);
            if (response.isClientError()) {
                throw TwilioRestException.parseResponse(response);
            }
            if (response.isServerError()) {
                try {
                    Thread.sleep(100 * retry);
                }
                catch (InterruptedException e) {}
                continue;
            }
            return response;
        }
        int errorCode = response == null ? -1 : response.getHttpStatus();
        throw new TwilioRestException("Cannot fetch: " + fullUri + " ", errorCode);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getAccountSid() {
        return this.accountSid;
    }
}

