/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.parser;

import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.parser.ResponseParser;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlResponseParser
implements ResponseParser {
    @Override
    public Map<String, Object> parse(TwilioRestResponse response) {
        Map<String, Object> xmlMap = this.parseXml(response.getResponseText());
        this.flattenMap(xmlMap, null, null);
        return xmlMap;
    }

    private void flattenMap(Map<String, Object> map, Map<String, Object> parentMap, String parentKey) {
        for (String key : map.keySet()) {
            Object data = map.get(key);
            if (data instanceof Map) {
                this.flattenMap((Map)data, map, key);
                continue;
            }
            if (!(data instanceof List)) continue;
            parentMap.put(parentKey, data);
        }
    }

    protected Map<String, Object> parseXml(String xmlString) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document d = builder.parse(new InputSource(new StringReader(xmlString)));
            Node resp = d.getFirstChild();
            NodeList nodes = resp.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                this.buildNode(node, ret);
            }
            if (resp.hasChildNodes() && resp.getFirstChild().hasAttributes()) {
                NamedNodeMap attrs = resp.getFirstChild().getAttributes();
                for (ResponseParser.PagingProperty p : ResponseParser.PagingProperty.values()) {
                    String property = this.getPagingPropertyKey(p);
                    Node n = attrs.getNamedItem(property);
                    ret.put(property, n.getNodeValue());
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void buildNode(Node currentNode, Map<String, Object> containerMap) {
        if (currentNode.hasChildNodes() && currentNode.getChildNodes().getLength() == 1 && currentNode.getFirstChild().getNodeType() == 3) {
            Node textNode = currentNode.getFirstChild();
            if (containerMap.containsKey(currentNode.getNodeName())) {
                Object oldObject = containerMap.get(currentNode.getNodeName());
                if (oldObject instanceof List) {
                    List array = (List)oldObject;
                    array.add(textNode.getNodeValue());
                } else {
                    ArrayList<Object> newList = new ArrayList<Object>();
                    newList.add(oldObject);
                    newList.add(textNode.getNodeValue());
                    containerMap.put(currentNode.getNodeName(), newList);
                }
            } else {
                containerMap.put(currentNode.getNodeName(), textNode.getNodeValue());
            }
        } else if (currentNode.hasChildNodes()) {
            NodeList nodes = currentNode.getChildNodes();
            HashMap<String, Object> newElement = new HashMap<String, Object>();
            if (containerMap.containsKey(currentNode.getNodeName())) {
                Object oldObject = containerMap.get(currentNode.getNodeName());
                if (oldObject instanceof List) {
                    List array = (List)oldObject;
                    array.add(newElement);
                } else {
                    ArrayList<Object> newList = new ArrayList<Object>();
                    newList.add(oldObject);
                    newList.add(newElement);
                    containerMap.put(currentNode.getNodeName(), newList);
                }
            } else {
                containerMap.put(currentNode.getNodeName(), newElement);
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                this.buildNode(node, newElement);
            }
        }
    }

    @Override
    public String getPagingPropertyKey(ResponseParser.PagingProperty prop) {
        switch (prop) {
            case NEXT_PAGE_URI_KEY: {
                return "nextpageuri";
            }
            case START_KEY: {
                return "start";
            }
            case END_KEY: {
                return "end";
            }
            case PAGE_KEY: {
                return "page";
            }
            case NUM_PAGES_KEY: {
                return "numpages";
            }
            case TOTAL_KEY: {
                return "total";
            }
        }
        return null;
    }
}

