/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance.taskrouter;

import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenInstanceResource;
import java.util.Calendar;
import java.util.Map;

public class WorkflowStatistics
extends NextGenInstanceResource<TwilioTaskRouterClient> {
    private static final String CUMULATIVE_PROPERTY = "cumulative";
    private static final String REALTIME_PROPERTY = "realtime";
    private static final String TASKS_BY_STATUS_PROPERTY = "tasks_by_status";
    private static final String WORKFLOW_SID_PROPERTY = "workflow_sid";
    private static final String WORKSPACE_SID_PROPERTY = "workspace_sid";

    public WorkflowStatistics(TwilioTaskRouterClient client, String workspaceSid, String workflowSid) {
        this(client, workspaceSid, workflowSid, null);
    }

    public WorkflowStatistics(TwilioTaskRouterClient client, String workspaceSid, String workflowSid, Map<String, String> filters) {
        super(client);
        if (workspaceSid == null || "".equals(workspaceSid)) {
            throw new IllegalArgumentException("The workspaceSid for a WorkflowStatistics cannot be null");
        }
        if (workflowSid == null || "".equals(workflowSid)) {
            throw new IllegalArgumentException("The workflowSid for a WorkflowStatistics cannot be null");
        }
        this.setProperty(WORKSPACE_SID_PROPERTY, workspaceSid);
        this.setProperty(WORKFLOW_SID_PROPERTY, workflowSid);
        this.filters = filters;
    }

    public Integer getAssignedTasks() {
        Map tasksByStatus = (Map)this.getRealtime().get(TASKS_BY_STATUS_PROPERTY);
        return (Integer)tasksByStatus.get("assigned");
    }

    public Double getAverageTaskAcceptanceTime() {
        try {
            Object prop = this.getCumulative().get("avg_task_acceptance_time");
            if (prop instanceof Integer) {
                return Double.parseDouble(prop.toString());
            }
            return (Double)prop;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Calendar getEndTime() {
        return this.parseCalendar((String)this.getCumulative().get("start_time"));
    }

    public Integer getLongestTaskWaitingAge() {
        return (Integer)this.getRealtime().get("longest_task_waiting_age");
    }

    public String getLongestTaskWaitingSid() {
        return (String)this.getRealtime().get("longest_task_waiting_sid");
    }

    public Integer getPendingTasks() {
        Map tasksByStatus = (Map)this.getRealtime().get(TASKS_BY_STATUS_PROPERTY);
        return (Integer)tasksByStatus.get("pending");
    }

    public Integer getReservationsAccepted() {
        return (Integer)this.getCumulative().get("reservations_accepted");
    }

    public Integer getReservationsRejected() {
        return (Integer)this.getCumulative().get("reservations_rejected");
    }

    public Integer getReservationsTimedOut() {
        return (Integer)this.getCumulative().get("reservations_timed_out");
    }

    public Integer getReservedTasks() {
        Map tasksByStatus = (Map)this.getRealtime().get(TASKS_BY_STATUS_PROPERTY);
        return (Integer)tasksByStatus.get("reserved");
    }

    public Calendar getStartTime() {
        return this.parseCalendar((String)this.getCumulative().get("start_time"));
    }

    public Integer getTasksCanceled() {
        return (Integer)this.getCumulative().get("tasks_canceled");
    }

    public Integer getTasksEntered() {
        return (Integer)this.getCumulative().get("tasks_entered");
    }

    public Integer getTasksMoved() {
        return (Integer)this.getCumulative().get("tasks_moved");
    }

    public Integer getTasksTimedOutInWorkflow() {
        return (Integer)this.getCumulative().get("tasks_timed_out_in_workflow");
    }

    public Integer getTotalTasks() {
        return (Integer)this.getRealtime().get("total_tasks");
    }

    public String getWorkflowSid() {
        return this.getProperty(WORKFLOW_SID_PROPERTY);
    }

    public String getWorkspaceSid() {
        return this.getProperty(WORKSPACE_SID_PROPERTY);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.getWorkspaceSid() + "/Workflows/" + this.getWorkflowSid() + "/Statistics";
    }

    private Map<String, Object> getCumulative() {
        return (Map)this.getObject(CUMULATIVE_PROPERTY);
    }

    private Map<String, Object> getRealtime() {
        return (Map)this.getObject(REALTIME_PROPERTY);
    }
}

