/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.list.taskrouter;

import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.TwilioTaskRouterClient;
import com.twilio.sdk.resource.NextGenListResource;
import com.twilio.sdk.resource.factory.taskrouter.WorkerFactory;
import com.twilio.sdk.resource.instance.taskrouter.Worker;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class WorkerList
extends NextGenListResource<Worker, TwilioTaskRouterClient>
implements WorkerFactory {
    private String workspaceSid;

    public WorkerList(TwilioTaskRouterClient client, String workspaceSid) {
        super(client);
        this.workspaceSid = workspaceSid;
    }

    public WorkerList(TwilioTaskRouterClient client, String workspaceSid, Map<String, String> filters) {
        super(client, filters);
        this.workspaceSid = workspaceSid;
    }

    @Override
    public Worker create(Map<String, String> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    @Override
    public Worker create(List<NameValuePair> params) throws TwilioRestException {
        TwilioRestResponse response = ((TwilioTaskRouterClient)this.getClient()).safeRequest(this.getResourceLocation(), "POST", params);
        return this.makeNew((TwilioTaskRouterClient)this.getClient(), response.toMap());
    }

    @Override
    protected Worker makeNew(TwilioTaskRouterClient client, Map<String, Object> params) {
        return new Worker(client, params);
    }

    @Override
    protected String getResourceLocation() {
        return "/v1/Workspaces/" + this.workspaceSid + "/Workers";
    }
}

