/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk;

import com.twilio.sdk.TwilioClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.resource.instance.conversations.Conversation;
import com.twilio.sdk.resource.instance.conversations.Participant;
import com.twilio.sdk.resource.list.conversations.CompletedConversationsList;
import com.twilio.sdk.resource.list.conversations.InProgressConversationsList;
import com.twilio.sdk.resource.list.conversations.ParticipantList;
import java.util.HashMap;
import java.util.Map;

public class TwilioConversationsClient
extends TwilioClient {
    public static final String DEFAULT_VERSION = "v1";
    private static final String PARTICIPANT_STATUS = "Status";
    private static final String PARTICIPANT_STATUS_DISCONNECTED = "disconnected";

    public TwilioConversationsClient(String username, String password) {
        super(username, password, "https://conversations.twilio.com");
    }

    public TwilioConversationsClient(String username, String password, String endpoint) {
        super(username, password, endpoint);
    }

    public Conversation getConversation(String conversationSid) {
        Conversation conversation = new Conversation(this, conversationSid);
        return conversation;
    }

    public CompletedConversationsList getCompletedConversations() {
        return new CompletedConversationsList(this, (Map<String, String>)new HashMap<String, String>(0));
    }

    public CompletedConversationsList getCompletedConversations(Map<String, String> filters) {
        return new CompletedConversationsList(this, filters);
    }

    public InProgressConversationsList getInProgressConversations() {
        return new InProgressConversationsList(this, (Map<String, String>)new HashMap<String, String>(0));
    }

    public InProgressConversationsList getInProgressConversations(Map<String, String> filters) {
        return new InProgressConversationsList(this, filters);
    }

    public Participant createParticipant(String conversationSid, Map<String, String> properties) throws TwilioRestException {
        ParticipantList participantFactory = new ParticipantList(this, conversationSid);
        return (Participant)participantFactory.create(properties);
    }

    public Participant getParticipant(String conversationSid, String participantSid) {
        Participant participant = new Participant(this, conversationSid, participantSid);
        return participant;
    }

    public Participant disconnectParticipant(String conversationSid, String participantSid) throws TwilioRestException {
        Participant participant = new Participant(this, conversationSid, participantSid);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARTICIPANT_STATUS, PARTICIPANT_STATUS_DISCONNECTED);
        participant.update(params);
        return participant;
    }

    public ParticipantList getParticipants(String conversationSid) {
        return new ParticipantList(this, new HashMap<String, String>(0), conversationSid);
    }

    public ParticipantList getParticipants(Map<String, String> filters, String conversationSid) {
        return new ParticipantList(this, filters, conversationSid);
    }
}

