/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Date;
import java.util.Map;

public class Application
extends InstanceResource<TwilioRestClient> {
    private static final String STATUS_PROPERTY = "status";
    private static final String FRIENDLY_NAME_PROPERTY = "friendly_name";

    public Application(TwilioRestClient client) {
        super(client);
    }

    public Application(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for an Application can not be null");
        }
        this.setProperty("sid", sid);
    }

    public Application(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Applications/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public String getFriendlyName() {
        return this.getProperty(FRIENDLY_NAME_PROPERTY);
    }

    public String getStatus() {
        return this.getProperty(STATUS_PROPERTY);
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }

    public String getVoiceUrl() {
        return this.getProperty("voice_url");
    }

    public String getVoiceMethod() {
        return this.getProperty("voice_method");
    }

    public String getVoiceFallbackUrl() {
        return this.getProperty("voice_fallback_url");
    }

    public String getVoiceFallbackMethod() {
        return this.getProperty("voice_fallback_method");
    }

    public String getStatusCallback() {
        return this.getProperty("status_callback");
    }

    public String getStatusCallbackMethod() {
        return this.getProperty("status_callback_method");
    }

    public String getVoiceCallerIdLookup() {
        return this.getProperty("voice_caller_id_lookup");
    }

    public String getSmsUrl() {
        return this.getProperty("sms_url");
    }

    public String getSmsMethod() {
        return this.getProperty("sms_method_url");
    }

    public String getSmsFallbackUrl() {
        return this.getProperty("sms_fallback_url");
    }

    public String getSmsFallbackMethod() {
        return this.getProperty("sms_fallback_method");
    }

    public String getSmsStatusCallback() {
        return this.getProperty("sms_status_callback");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

