/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import java.util.Date;
import java.util.Map;

public class Notification
extends InstanceResource<TwilioRestClient> {
    public Notification(TwilioRestClient client) {
        super(client);
    }

    public Notification(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a Notification can not be null");
        }
        this.setProperty("sid", sid);
    }

    public Notification(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Notifications/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public Date getDateCreated() {
        return this.getDateProperty("date_created");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("date_updated");
    }

    public String getAccountSid() {
        return this.getProperty("account_sid");
    }

    public String getCallSid() {
        return this.getProperty("call_sid");
    }

    public String getApiVersion() {
        return this.getProperty("api_version");
    }

    public String getLog() {
        return this.getProperty("log");
    }

    public String getErrorCode() {
        return this.getProperty("error_code");
    }

    public String getMoreInfo() {
        return this.getProperty("more_info");
    }

    public String getMessageText() {
        return this.getProperty("message_text");
    }

    public String getMessageDate() {
        return this.getProperty("message_date");
    }

    public String getRequestUrl() {
        return this.getProperty("request_url");
    }

    public String getRequestVariables() {
        return this.getProperty("request_variables");
    }

    public String getResponseHeaders() {
        return this.getProperty("response_headers");
    }

    public String getResponseBody() {
        return this.getProperty("response_body");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

