/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.instance;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.TwilioRestResponse;
import com.twilio.sdk.resource.InstanceResource;
import com.twilio.sdk.resource.instance.Recurrence;
import com.twilio.sdk.resource.instance.Trigger;
import com.twilio.sdk.resource.instance.UsageCategory;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class UsageTrigger
extends InstanceResource<TwilioRestClient> {
    public UsageTrigger(TwilioRestClient client) {
        super(client);
    }

    @Override
    protected String getResourceLocation() {
        return "/2010-04-01/Accounts/" + this.getRequestAccountSid() + "/Usage/Triggers/" + this.getSid() + ".json";
    }

    public String getSid() {
        return this.getProperty("sid");
    }

    public UsageTrigger(TwilioRestClient client, String sid) {
        super(client);
        if (sid == null) {
            throw new IllegalStateException("The Sid for a UsageRecord can not be null");
        }
        this.setProperty("sid", sid);
    }

    public UsageTrigger(TwilioRestClient client, Map<String, Object> properties) {
        super(client, properties);
    }

    public Date getDateCreated() {
        return this.getDateProperty("DateCreated");
    }

    public Date getDateUpdated() {
        return this.getDateProperty("DateUpdated");
    }

    public String getFriendlyName() {
        return this.getProperty("FriendlyName");
    }

    public Recurrence getRecurring() {
        return Recurrence.valueOf(this.getProperty("Recurring"));
    }

    public UsageCategory getUsageCategory() {
        return UsageCategory.valueOf(this.getProperty("UsageCategory"));
    }

    public Trigger getTriggerBy() {
        return Trigger.valueOf(this.getProperty("TriggerBy"));
    }

    public BigDecimal getTriggerValue() {
        return new BigDecimal(this.getProperty("TriggerValue"));
    }

    public BigDecimal getCurrentValue() {
        return new BigDecimal(this.getProperty("CurrentValue"));
    }

    public String getUsageRecordUri() {
        return this.getProperty("UsageRecordUri");
    }

    public String getCallbackUrl() {
        return this.getProperty("CallbackUrl");
    }

    public String getCallbackMethod() {
        return this.getProperty("CallbackMethod");
    }

    public Date getDateFired() {
        return this.getDateProperty("DateFired");
    }

    public String getUri() {
        return this.getProperty("Uri");
    }

    public String getAccountSid() {
        return this.getProperty("AccountSid");
    }

    public boolean delete() throws TwilioRestException {
        TwilioRestResponse response = ((TwilioRestClient)this.getClient()).safeRequest(this.getResourceLocation(), "DELETE", (Map<String, String>)null);
        return !response.isError();
    }
}

