/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.api.v2010.account.sip.domain;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.sip.domain.CredentialListMapping;

public class CredentialListMappingCreator
extends Creator<CredentialListMapping> {
    private final String accountSid;
    private final String domainSid;
    private final String credentialListSid;

    public CredentialListMappingCreator(String accountSid, String domainSid, String credentialListSid) {
        this.accountSid = accountSid;
        this.domainSid = domainSid;
        this.credentialListSid = credentialListSid;
    }

    @Override
    public CredentialListMapping execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/SIP/Domains/" + this.domainSid + "/CredentialListMappings.json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CredentialListMapping creation failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 201) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return CredentialListMapping.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.credentialListSid != null) {
            request.addPostParam("CredentialListSid", this.credentialListSid);
        }
    }
}

