/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.api.v2010.account.sip.ipaccesscontrollist;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.sip.ipaccesscontrollist.IpAddress;

public class IpAddressCreator
extends Creator<IpAddress> {
    private final String accountSid;
    private final String ipAccessControlListSid;
    private final String friendlyName;
    private final String ipAddress;

    public IpAddressCreator(String accountSid, String ipAccessControlListSid, String friendlyName, String ipAddress) {
        this.accountSid = accountSid;
        this.ipAccessControlListSid = ipAccessControlListSid;
        this.friendlyName = friendlyName;
        this.ipAddress = ipAddress;
    }

    @Override
    public IpAddress execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/SIP/IpAccessControlLists/" + this.ipAccessControlListSid + "/IpAddresses.json", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("IpAddress creation failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 201) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return IpAddress.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.ipAddress != null) {
            request.addPostParam("IpAddress", this.ipAddress);
        }
    }
}

