/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.creator.notifications.v1.service;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.converter.Promoter;
import com.twilio.sdk.creator.Creator;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.notifications.v1.service.Binding;
import java.util.List;

public class BindingCreator
extends Creator<Binding> {
    private final String serviceSid;
    private final String endpoint;
    private final String identity;
    private final Binding.BindingType bindingType;
    private final String address;
    private List<String> tag;
    private String notificationProtocolVersion;

    public BindingCreator(String serviceSid, String endpoint, String identity, Binding.BindingType bindingType, String address) {
        this.serviceSid = serviceSid;
        this.endpoint = endpoint;
        this.identity = identity;
        this.bindingType = bindingType;
        this.address = address;
    }

    public BindingCreator setTag(List<String> tag) {
        this.tag = tag;
        return this;
    }

    public BindingCreator setTag(String tag) {
        return this.setTag(Promoter.listOfOne(tag));
    }

    public BindingCreator setNotificationProtocolVersion(String notificationProtocolVersion) {
        this.notificationProtocolVersion = notificationProtocolVersion;
        return this;
    }

    @Override
    public Binding execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.NOTIFICATIONS, "/v1/Services/" + this.serviceSid + "/Bindings", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Binding creation failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 201) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Binding.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.endpoint != null) {
            request.addPostParam("Endpoint", this.endpoint);
        }
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.bindingType != null) {
            request.addPostParam("BindingType", this.bindingType.toString());
        }
        if (this.address != null) {
            request.addPostParam("Address", this.address);
        }
        if (this.tag != null) {
            for (String prop : this.tag) {
                request.addPostParam("Tag", prop.toString());
            }
        }
        if (this.notificationProtocolVersion != null) {
            request.addPostParam("NotificationProtocolVersion", this.notificationProtocolVersion);
        }
    }
}

