/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.api.v2010.account.queue;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.queue.Member;

public class MemberFetcher
extends Fetcher<Member> {
    private final String accountSid;
    private final String queueSid;
    private final String callSid;

    public MemberFetcher(String accountSid, String queueSid, String callSid) {
        this.accountSid = accountSid;
        this.queueSid = queueSid;
        this.callSid = callSid;
    }

    @Override
    public Member execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Queues/" + this.queueSid + "/Members/" + this.callSid + ".json", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member fetch failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Member.fromJson(response.getStream(), client.getObjectMapper());
    }
}

