/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.notifications.v1.service;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.notifications.v1.service.Binding;

public class BindingFetcher
extends Fetcher<Binding> {
    private final String serviceSid;
    private final String sid;

    public BindingFetcher(String serviceSid, String sid) {
        this.serviceSid = serviceSid;
        this.sid = sid;
    }

    @Override
    public Binding execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.NOTIFICATIONS, "/v1/Services/" + this.serviceSid + "/Bindings/" + this.sid + "", client.getAccountSid());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Binding fetch failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Binding.fromJson(response.getStream(), client.getObjectMapper());
    }
}

