/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.fetcher.taskrouter.v1.workspace;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.Fetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.WorkspaceStatistics;

public class WorkspaceStatisticsFetcher
extends Fetcher<WorkspaceStatistics> {
    private final String workspaceSid;
    private Integer minutes;
    private String startDate;
    private String endDate;

    public WorkspaceStatisticsFetcher(String workspaceSid) {
        this.workspaceSid = workspaceSid;
    }

    public WorkspaceStatisticsFetcher setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public WorkspaceStatisticsFetcher setStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public WorkspaceStatisticsFetcher setEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Override
    public WorkspaceStatistics execute(TwilioRestClient client) {
        Response response;
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Statistics", client.getAccountSid());
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate);
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate);
        }
        if ((response = client.request(request)) == null) {
            throw new ApiConnectionException("WorkspaceStatistics fetch failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return WorkspaceStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }
}

