/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.http;

import com.google.common.collect.Lists;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpClient;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class NetworkHttpClient
extends HttpClient {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final HttpVersion HTTP_1_1 = new HttpVersion(1, 1);
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 30500;
    private final org.apache.http.client.HttpClient client;

    public NetworkHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30500).build();
        ArrayList headers = Lists.newArrayList((Object[])new Header[]{new BasicHeader("X-Twilio-Client", "java-7.0.0-rc-3"), new BasicHeader("User-Agent", "twilio-java/7.0.0-rc-3"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "utf-8")});
        this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).setDefaultRequestConfig(config).setDefaultHeaders((Collection)headers).setMaxConnPerRoute(10).build();
    }

    @Override
    public Response makeRequest(Request request) {
        HttpMethod method;
        RequestBuilder builder = RequestBuilder.create((String)request.getMethod().toString()).setUri(request.constructURL().toString()).setVersion((ProtocolVersion)HTTP_1_1).setCharset(UTF_8);
        if (request.requiresAuthentication()) {
            builder.addHeader("Authorization", request.getAuthString());
        }
        if ((method = request.getMethod()) == HttpMethod.POST) {
            builder.addHeader("Content-Type", "application/x-www-form-urlencoded");
            for (Map.Entry<String, List<String>> entry : request.getPostParams().entrySet()) {
                for (String value : entry.getValue()) {
                    builder.addParameter(entry.getKey(), value);
                }
            }
        }
        try {
            HttpResponse response = this.client.execute(builder.build());
            return new Response(response.getEntity() == null ? null : response.getEntity().getContent(), response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new ApiException(e.getMessage());
        }
    }
}

