/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.http;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpClient;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class NingHttpClient
extends HttpClient {
    @Override
    public Response makeRequest(Request request) {
        AsyncHttpClient.BoundRequestBuilder builder;
        String method;
        if (request.getMethod() == null) {
            throw new ApiConnectionException("Request has no method");
        }
        AsyncHttpClient client = new AsyncHttpClient();
        switch (method = request.getMethod().toString()) {
            case "GET": {
                builder = client.prepareGet(request.getUri());
                break;
            }
            case "POST": {
                builder = client.preparePost(request.getUri());
                break;
            }
            case "DELETE": {
                builder = client.prepareDelete(request.getUri());
                break;
            }
            default: {
                throw new ApiConnectionException(method + " is not a supported HTTP Method");
            }
        }
        if (request.requiresAuthentication()) {
            builder.addHeader("Authorization", request.getAuthString());
        }
        try {
            ListenableFuture future = builder.execute();
            com.ning.http.client.Response response = (com.ning.http.client.Response)future.get();
            return new Response(response.getResponseBody(), response.getStatusCode());
        }
        catch (IOException e) {
            throw new ApiConnectionException("IOException during API request to Twilio", e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ApiException(e.getMessage(), e);
        }
    }
}

