/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account.message;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.message.Media;

public class MediaReader
extends Reader<Media> {
    private final String accountSid;
    private final String messageSid;
    private String dateCreated;

    public MediaReader(String accountSid, String messageSid) {
        this.accountSid = accountSid;
        this.messageSid = messageSid;
    }

    public MediaReader byDateCreated(String dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @Override
    public ResourceSet<Media> execute(TwilioRestClient client) {
        return new ResourceSet<Media>(this, client, this.firstPage());
    }

    @Override
    public Page<Media> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Messages/" + this.messageSid + "/Media.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Media> nextPage(Page<Media> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Media> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Media read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("media_list", response.getContent(), Media.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.dateCreated != null) {
            request.addQueryParam("DateCreated", this.dateCreated);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

