/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account.usage;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.usage.Trigger;

public class TriggerReader
extends Reader<Trigger> {
    private final String accountSid;
    private Trigger.Recurring recurring;
    private Trigger.TriggerField triggerBy;
    private Trigger.UsageCategory usageCategory;

    public TriggerReader(String accountSid) {
        this.accountSid = accountSid;
    }

    public TriggerReader byRecurring(Trigger.Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    public TriggerReader byTriggerBy(Trigger.TriggerField triggerBy) {
        this.triggerBy = triggerBy;
        return this;
    }

    public TriggerReader byUsageCategory(Trigger.UsageCategory usageCategory) {
        this.usageCategory = usageCategory;
        return this;
    }

    @Override
    public ResourceSet<Trigger> execute(TwilioRestClient client) {
        return new ResourceSet<Trigger>(this, client, this.firstPage());
    }

    @Override
    public Page<Trigger> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Usage/Triggers.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Trigger> nextPage(Page<Trigger> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Trigger> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Trigger read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("usage_triggers", response.getContent(), Trigger.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.recurring != null) {
            request.addQueryParam("Recurring", this.recurring.toString());
        }
        if (this.triggerBy != null) {
            request.addQueryParam("TriggerBy", this.triggerBy.toString());
        }
        if (this.usageCategory != null) {
            request.addQueryParam("UsageCategory", this.usageCategory.toString());
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

