/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.api.v2010.account.usage.record;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.api.v2010.account.usage.record.LastMonth;

public class LastMonthReader
extends Reader<LastMonth> {
    private final String accountSid;

    public LastMonthReader(String accountSid) {
        this.accountSid = accountSid;
    }

    @Override
    public ResourceSet<LastMonth> execute(TwilioRestClient client) {
        return new ResourceSet<LastMonth>(this, client, this.firstPage());
    }

    @Override
    public Page<LastMonth> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.API, "/2010-04-01/Accounts/" + this.accountSid + "/Usage/Records/LastMonth.json", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<LastMonth> nextPage(Page<LastMonth> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<LastMonth> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("LastMonth read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("usage_records", response.getContent(), LastMonth.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

