/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.monitor.v1;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.monitor.v1.Alert;

public class AlertReader
extends Reader<Alert> {
    private String logLevel;
    private String startDate;
    private String endDate;

    public AlertReader byLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public AlertReader byStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public AlertReader byEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    @Override
    public ResourceSet<Alert> execute(TwilioRestClient client) {
        return new ResourceSet<Alert>(this, client, this.firstPage());
    }

    @Override
    public Page<Alert> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.MONITOR, "/v1/Alerts", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Alert> nextPage(Page<Alert> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Alert> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Alert read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("alerts", response.getContent(), Alert.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.logLevel != null) {
            request.addQueryParam("LogLevel", this.logLevel);
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate);
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

