/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.reader.taskrouter.v1.workspace.task;

import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.reader.Reader;
import com.twilio.sdk.resource.Page;
import com.twilio.sdk.resource.ResourceSet;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.taskrouter.v1.workspace.task.Reservation;

public class ReservationReader
extends Reader<Reservation> {
    private final String workspaceSid;
    private final String taskSid;
    private String status;
    private String assignmentStatus;
    private String reservationStatus;

    public ReservationReader(String workspaceSid, String taskSid) {
        this.workspaceSid = workspaceSid;
        this.taskSid = taskSid;
    }

    public ReservationReader byStatus(String status) {
        this.status = status;
        return this;
    }

    public ReservationReader byAssignmentStatus(String assignmentStatus) {
        this.assignmentStatus = assignmentStatus;
        return this;
    }

    public ReservationReader byReservationStatus(String reservationStatus) {
        this.reservationStatus = reservationStatus;
        return this;
    }

    @Override
    public ResourceSet<Reservation> execute(TwilioRestClient client) {
        return new ResourceSet<Reservation>(this, client, this.firstPage());
    }

    @Override
    public Page<Reservation> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, TwilioRestClient.Domains.TASKROUTER, "/v1/Workspaces/" + this.workspaceSid + "/Tasks/" + this.taskSid + "/Reservations", client.getAccountSid());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Reservation> nextPage(Page<Reservation> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUri(), client.getAccountSid());
        return this.pageForRequest(client, request);
    }

    private Page<Reservation> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Reservation read failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("reservations", response.getContent(), Reservation.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.status != null) {
            request.addQueryParam("Status", this.status);
        }
        if (this.assignmentStatus != null) {
            request.addQueryParam("AssignmentStatus", this.assignmentStatus);
        }
        if (this.reservationStatus != null) {
            request.addQueryParam("ReservationStatus", this.reservationStatus);
        }
        request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
    }
}

