/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.CurrencyDeserializer;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.api.v2010.account.MessageCreator;
import com.twilio.sdk.deleter.api.v2010.account.MessageDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.MessageFetcher;
import com.twilio.sdk.reader.api.v2010.account.MessageReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.type.PhoneNumber;
import com.twilio.sdk.updater.api.v2010.account.MessageUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
extends SidResource {
    private static final long serialVersionUID = 8764009288306L;
    private final String accountSid;
    private final String apiVersion;
    private final String body;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime dateSent;
    private final Direction direction;
    private final Integer errorCode;
    private final String errorMessage;
    private final PhoneNumber from;
    private final String numMedia;
    private final String numSegments;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final String sid;
    private final Status status;
    private final Map<String, String> subresourceUris;
    private final String to;
    private final String uri;

    public static MessageCreator create(String accountSid, PhoneNumber to, PhoneNumber from, String body) {
        return new MessageCreator(accountSid, to, from, body);
    }

    public static MessageCreator create(String accountSid, PhoneNumber to, PhoneNumber from, List<URI> mediaUrl) {
        return new MessageCreator(accountSid, to, from, mediaUrl);
    }

    public static MessageDeleter delete(String accountSid, String sid) {
        return new MessageDeleter(accountSid, sid);
    }

    public static MessageFetcher fetch(String accountSid, String sid) {
        return new MessageFetcher(accountSid, sid);
    }

    public static MessageReader read(String accountSid) {
        return new MessageReader(accountSid);
    }

    public static MessageUpdater update(String accountSid, String sid) {
        return new MessageUpdater(accountSid, sid);
    }

    public static Message fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Message)objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Message fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Message)objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Message(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="body") String body, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_sent") String dateSent, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="error_message") String errorMessage, @JsonProperty(value="from") PhoneNumber from, @JsonProperty(value="num_media") String numMedia, @JsonProperty(value="num_segments") String numSegments, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris, @JsonProperty(value="to") String to, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.body = body;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.dateSent = DateConverter.rfc2822DateTimeFromString(dateSent);
        this.direction = direction;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.from = from;
        this.numMedia = numMedia;
        this.numSegments = numSegments;
        this.price = price;
        this.priceUnit = priceUnit;
        this.sid = sid;
        this.status = status;
        this.subresourceUris = subresourceUris;
        this.to = to;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getBody() {
        return this.body;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final DateTime getDateSent() {
        return this.dateSent;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final PhoneNumber getFrom() {
        return this.from;
    }

    public final String getNumMedia() {
        return this.numMedia;
    }

    public final String getNumSegments() {
        return this.numSegments;
    }

    public final BigDecimal getPrice() {
        return this.price;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public final String getTo() {
        return this.to;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.body, other.body) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateSent, other.dateSent) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.from, other.from) && Objects.equals(this.numMedia, other.numMedia) && Objects.equals(this.numSegments, other.numSegments) && Objects.equals(this.price, other.price) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.subresourceUris, other.subresourceUris) && Objects.equals(this.to, other.to) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.body, this.dateCreated, this.dateUpdated, this.dateSent, this.direction, this.errorCode, this.errorMessage, this.from, this.numMedia, this.numSegments, this.price, this.priceUnit, this.sid, this.status, this.subresourceUris, this.to, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("apiVersion", (Object)this.apiVersion).add("body", (Object)this.body).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("dateSent", (Object)this.dateSent).add("direction", (Object)this.direction).add("errorCode", (Object)this.errorCode).add("errorMessage", (Object)this.errorMessage).add("from", (Object)this.from).add("numMedia", (Object)this.numMedia).add("numSegments", (Object)this.numSegments).add("price", (Object)this.price).add("priceUnit", (Object)this.priceUnit).add("sid", (Object)this.sid).add("status", (Object)this.status).add("subresourceUris", this.subresourceUris).add("to", (Object)this.to).add("uri", (Object)this.uri).toString();
    }

    public static enum Direction {
        INBOUND("inbound"),
        OUTBOUND_API("outbound-api"),
        OUTBOUND_CALL("outbound-call"),
        OUTBOUND_REPLY("outbound-reply");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Direction forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Direction.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }

    public static enum Status {
        QUEUED("queued"),
        SENDING("sending"),
        SENT("sent"),
        FAILED("failed"),
        DELIVERED("delivered"),
        UNDELIVERED("undelivered"),
        RECEIVING("receiving"),
        RECEIVED("received");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return Status.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

