/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.api.v2010.account.queue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.api.v2010.account.queue.MemberFetcher;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.reader.api.v2010.account.queue.MemberReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.api.v2010.account.queue.MemberUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Member
extends SidResource {
    private static final long serialVersionUID = 27782479642114L;
    private final String callSid;
    private final DateTime dateEnqueued;
    private final Integer position;
    private final String uri;
    private final Integer waitTime;

    public static MemberFetcher fetch(String accountSid, String queueSid, String callSid) {
        return new MemberFetcher(accountSid, queueSid, callSid);
    }

    public static MemberUpdater update(String accountSid, String queueSid, String callSid, URI url, HttpMethod method) {
        return new MemberUpdater(accountSid, queueSid, callSid, url, method);
    }

    public static MemberReader read(String accountSid, String queueSid) {
        return new MemberReader(accountSid, queueSid);
    }

    public static Member fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Member)objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Member fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Member)objectMapper.readValue(json, Member.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Member(@JsonProperty(value="call_sid") String callSid, @JsonProperty(value="date_enqueued") String dateEnqueued, @JsonProperty(value="position") Integer position, @JsonProperty(value="uri") String uri, @JsonProperty(value="wait_time") Integer waitTime) {
        this.callSid = callSid;
        this.dateEnqueued = DateConverter.rfc2822DateTimeFromString(dateEnqueued);
        this.position = position;
        this.uri = uri;
        this.waitTime = waitTime;
    }

    @Override
    public final String getSid() {
        return this.getCallSid();
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final DateTime getDateEnqueued() {
        return this.dateEnqueued;
    }

    public final Integer getPosition() {
        return this.position;
    }

    public final String getUri() {
        return this.uri;
    }

    public final Integer getWaitTime() {
        return this.waitTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member other = (Member)o;
        return Objects.equals(this.callSid, other.callSid) && Objects.equals(this.dateEnqueued, other.dateEnqueued) && Objects.equals(this.position, other.position) && Objects.equals(this.uri, other.uri) && Objects.equals(this.waitTime, other.waitTime);
    }

    public int hashCode() {
        return Objects.hash(this.callSid, this.dateEnqueued, this.position, this.uri, this.waitTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("callSid", (Object)this.callSid).add("dateEnqueued", (Object)this.dateEnqueued).add("position", (Object)this.position).add("uri", (Object)this.uri).add("waitTime", (Object)this.waitTime).toString();
    }
}

