/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.notifications.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.creator.notifications.v1.service.BindingCreator;
import com.twilio.sdk.deleter.notifications.v1.service.BindingDeleter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.notifications.v1.service.BindingFetcher;
import com.twilio.sdk.reader.notifications.v1.service.BindingReader;
import com.twilio.sdk.resource.SidResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Binding
extends SidResource {
    private static final long serialVersionUID = 72408629014564L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String notificationProtocolVersion;
    private final String endpoint;
    private final String identity;
    private final String bindingType;
    private final String address;
    private final List<String> tags;
    private final URI url;

    public static BindingFetcher fetch(String serviceSid, String sid) {
        return new BindingFetcher(serviceSid, sid);
    }

    public static BindingDeleter delete(String serviceSid, String sid) {
        return new BindingDeleter(serviceSid, sid);
    }

    public static BindingCreator create(String serviceSid, String endpoint, String identity, BindingType bindingType, String address) {
        return new BindingCreator(serviceSid, endpoint, identity, bindingType, address);
    }

    public static BindingReader read(String serviceSid) {
        return new BindingReader(serviceSid);
    }

    public static Binding fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Binding)objectMapper.readValue(json, Binding.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Binding fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Binding)objectMapper.readValue(json, Binding.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Binding(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="notification_protocol_version") String notificationProtocolVersion, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="identity") String identity, @JsonProperty(value="binding_type") String bindingType, @JsonProperty(value="address") String address, @JsonProperty(value="tags") List<String> tags, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.notificationProtocolVersion = notificationProtocolVersion;
        this.endpoint = endpoint;
        this.identity = identity;
        this.bindingType = bindingType;
        this.address = address;
        this.tags = tags;
        this.url = url;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getNotificationProtocolVersion() {
        return this.notificationProtocolVersion;
    }

    public final String getEndpoint() {
        return this.endpoint;
    }

    public final String getIdentity() {
        return this.identity;
    }

    public final String getBindingType() {
        return this.bindingType;
    }

    public final String getAddress() {
        return this.address;
    }

    public final List<String> getTags() {
        return this.tags;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binding other = (Binding)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.notificationProtocolVersion, other.notificationProtocolVersion) && Objects.equals(this.endpoint, other.endpoint) && Objects.equals(this.identity, other.identity) && Objects.equals(this.bindingType, other.bindingType) && Objects.equals(this.address, other.address) && Objects.equals(this.tags, other.tags) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.dateUpdated, this.notificationProtocolVersion, this.endpoint, this.identity, this.bindingType, this.address, this.tags, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("notificationProtocolVersion", (Object)this.notificationProtocolVersion).add("endpoint", (Object)this.endpoint).add("identity", (Object)this.identity).add("bindingType", (Object)this.bindingType).add("address", (Object)this.address).add("tags", this.tags).add("url", (Object)this.url).toString();
    }

    public static enum BindingType {
        APN("apn"),
        GCM("gcm");

        private final String value;

        private BindingType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static BindingType forValue(String value) {
            String normalized = value.replace("-", "_").toUpperCase();
            try {
                return BindingType.valueOf(normalized);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }
}

