/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.taskrouter.v1.workspace.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.converter.DateConverter;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.taskrouter.v1.workspace.task.ReservationFetcher;
import com.twilio.sdk.reader.taskrouter.v1.workspace.task.ReservationReader;
import com.twilio.sdk.resource.SidResource;
import com.twilio.sdk.updater.taskrouter.v1.workspace.task.ReservationUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Reservation
extends SidResource {
    private static final long serialVersionUID = 269071000200631L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String reservationStatus;
    private final String sid;
    private final String taskSid;
    private final String workerName;
    private final String workerSid;
    private final String workspaceSid;

    public static ReservationReader read(String workspaceSid, String taskSid) {
        return new ReservationReader(workspaceSid, taskSid);
    }

    public static ReservationFetcher fetch(String workspaceSid, String taskSid, String sid) {
        return new ReservationFetcher(workspaceSid, taskSid, sid);
    }

    public static ReservationUpdater update(String workspaceSid, String taskSid, String sid, String reservationStatus) {
        return new ReservationUpdater(workspaceSid, taskSid, sid, reservationStatus);
    }

    public static Reservation fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Reservation)objectMapper.readValue(json, Reservation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Reservation fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Reservation)objectMapper.readValue(json, Reservation.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Reservation(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="reservation_status") String reservationStatus, @JsonProperty(value="sid") String sid, @JsonProperty(value="task_sid") String taskSid, @JsonProperty(value="worker_name") String workerName, @JsonProperty(value="worker_sid") String workerSid, @JsonProperty(value="workspace_sid") String workspaceSid) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.reservationStatus = reservationStatus;
        this.sid = sid;
        this.taskSid = taskSid;
        this.workerName = workerName;
        this.workerSid = workerSid;
        this.workspaceSid = workspaceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getReservationStatus() {
        return this.reservationStatus;
    }

    @Override
    public final String getSid() {
        return this.sid;
    }

    public final String getTaskSid() {
        return this.taskSid;
    }

    public final String getWorkerName() {
        return this.workerName;
    }

    public final String getWorkerSid() {
        return this.workerSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reservation other = (Reservation)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.reservationStatus, other.reservationStatus) && Objects.equals(this.sid, other.sid) && Objects.equals(this.taskSid, other.taskSid) && Objects.equals(this.workerName, other.workerName) && Objects.equals(this.workerSid, other.workerSid) && Objects.equals(this.workspaceSid, other.workspaceSid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.reservationStatus, this.sid, this.taskSid, this.workerName, this.workerSid, this.workspaceSid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("reservationStatus", (Object)this.reservationStatus).add("sid", (Object)this.sid).add("taskSid", (Object)this.taskSid).add("workerName", (Object)this.workerName).add("workerSid", (Object)this.workerSid).add("workspaceSid", (Object)this.workspaceSid).toString();
    }
}

