/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.resource.taskrouter.v1.workspace.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.fetcher.taskrouter.v1.workspace.worker.WorkersStatisticsFetcher;
import com.twilio.sdk.resource.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkersStatistics
extends Resource {
    private static final long serialVersionUID = 176548291123699L;
    private final String accountSid;
    private final JsonNode cumulative;
    private final JsonNode realtime;
    private final String workspaceSid;

    public static WorkersStatisticsFetcher fetch(String workspaceSid) {
        return new WorkersStatisticsFetcher(workspaceSid);
    }

    public static WorkersStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (WorkersStatistics)objectMapper.readValue(json, WorkersStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkersStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (WorkersStatistics)objectMapper.readValue(json, WorkersStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkersStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="cumulative") JsonNode cumulative, @JsonProperty(value="realtime") JsonNode realtime, @JsonProperty(value="workspace_sid") String workspaceSid) {
        this.accountSid = accountSid;
        this.cumulative = cumulative;
        this.realtime = realtime;
        this.workspaceSid = workspaceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final JsonNode getCumulative() {
        return this.cumulative;
    }

    public final JsonNode getRealtime() {
        return this.realtime;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkersStatistics other = (WorkersStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.cumulative, other.cumulative) && Objects.equals(this.realtime, other.realtime) && Objects.equals(this.workspaceSid, other.workspaceSid);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.cumulative, this.realtime, this.workspaceSid);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("cumulative", (Object)this.cumulative).add("realtime", (Object)this.realtime).add("workspaceSid", (Object)this.workspaceSid).toString();
    }
}

