/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.sdk.updater.ipmessaging.v1.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.twilio.sdk.client.TwilioRestClient;
import com.twilio.sdk.exception.ApiConnectionException;
import com.twilio.sdk.exception.ApiException;
import com.twilio.sdk.http.HttpMethod;
import com.twilio.sdk.http.Request;
import com.twilio.sdk.http.Response;
import com.twilio.sdk.resource.RestException;
import com.twilio.sdk.resource.ipmessaging.v1.service.Channel;
import com.twilio.sdk.updater.Updater;

public class ChannelUpdater
extends Updater<Channel> {
    private final String serviceSid;
    private final String sid;
    private String friendlyName;
    private String uniqueName;
    private JsonNode attributes;
    private Channel.ChannelType type;

    public ChannelUpdater(String serviceSid, String sid) {
        this.serviceSid = serviceSid;
        this.sid = sid;
    }

    public ChannelUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ChannelUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public ChannelUpdater setAttributes(JsonNode attributes) {
        this.attributes = attributes;
        return this;
    }

    public ChannelUpdater setType(Channel.ChannelType type) {
        this.type = type;
        return this;
    }

    @Override
    public Channel execute(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, TwilioRestClient.Domains.IPMESSAGING, "/v1/Services/" + this.serviceSid + "/Channels/" + this.sid + "", client.getAccountSid());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Channel update failed: Unable to connect to server");
        }
        if (response.getStatusCode() != 200) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Channel.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes.toString());
        }
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
    }
}

