/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.twilio.taskrouter.WorkflowRuleTarget;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class WorkflowRule {
    private String expression;
    private String friendlyName;
    private List<WorkflowRuleTarget> targets;

    public WorkflowRule(String expression, List<WorkflowRuleTarget> targets) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)expression)) {
            throw new IllegalArgumentException("Expression for Workflow Rule is required");
        }
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Targets for Workflow Rule are required");
        }
        this.expression = expression;
        this.targets = targets;
    }

    @JsonCreator
    public WorkflowRule(@JsonProperty(value="expression") String expression, @JsonProperty(value="targets") List<WorkflowRuleTarget> targets, @JsonProperty(value="friendly_name") String friendlyName) throws IllegalArgumentException {
        this(expression, targets);
        this.friendlyName = friendlyName;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    @JsonProperty(value="friendly_name")
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @JsonIgnore
    public String getFilterFriendlyName() {
        return this.friendlyName;
    }

    @JsonProperty(value="filter_friendly_name")
    public void setFilterFriendlyName(String filterFriendlyName) {
        this.friendlyName = filterFriendlyName;
    }

    @JsonIgnore
    public List<WorkflowRuleTarget> getWorkflowRuleTargets() {
        return this.targets;
    }

    public void setWorkflowRuleTargets(List<WorkflowRuleTarget> targets) {
        this.targets = targets;
    }

    public void addWorkflowRuleTarget(WorkflowRuleTarget target) {
        this.targets.add(target);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", (Object)this.expression).add("friendlyName", (Object)this.friendlyName).add("targets", this.targets).toString();
    }
}

