/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class WorkflowRuleTarget {
    private String queue;
    private String expression;
    private Integer priority;
    private Integer timeout;

    public WorkflowRuleTarget(String queue) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)queue)) {
            throw new IllegalArgumentException("QueueSid is required when defining a Workflow Rule Target");
        }
        this.queue = queue;
    }

    @JsonCreator
    public WorkflowRuleTarget(@JsonProperty(value="queue") String queue, @JsonProperty(value="expression") String expression, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="timeout") Integer timeout) throws IllegalArgumentException {
        this(queue);
        this.expression = expression;
        this.priority = priority;
        this.timeout = timeout;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queue", (Object)this.queue).add("expression", (Object)this.expression).add("priority", (Object)this.priority).add("timeout", (Object)this.timeout).toString();
    }
}

