/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twilsock.client;

import com.twilio.twilsock.client.TwilsockClientUpdateMessage;
import com.twilio.twilsock.client.TwilsockCloseMessage;
import com.twilio.twilsock.client.TwilsockMessage;
import com.twilio.twilsock.client.TwilsockNotificationMessage;
import com.twilio.twilsock.client.TwilsockPingMessage;
import com.twilio.twilsock.client.TwilsockReplyMessage;
import com.twilio.util.InternalUtilsKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0003H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0003*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"TWILSOCK_PREFIX", "", "encode", "Lcom/twilio/twilsock/client/TwilsockMessage;", "encodeToByteArray", "", "parse", "Lcom/twilio/twilsock/client/TwilsockMessage$Companion;", "message", "twilsock_release"})
@SourceDebugExtension(value={"SMAP\nTwilsockMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwilsockMessage.kt\ncom/twilio/twilsock/client/TwilsockMessageKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,146:1\n1#2:147\n211#3:148\n222#3:149\n*S KotlinDebug\n*F\n+ 1 TwilsockMessage.kt\ncom/twilio/twilsock/client/TwilsockMessageKt\n*L\n109#1:148\n129#1:149\n*E\n"})
public final class TwilsockMessageKt {
    @NotNull
    private static final String TWILSOCK_PREFIX = "TWILSOCK V3.0";

    @NotNull
    public static final byte[] encodeToByteArray(@NotNull TwilsockMessage $this$encodeToByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeToByteArray, (String)"<this>");
        byte[] byArray = $this$encodeToByteArray.getRawMessage();
        if (byArray == null) {
            byArray = StringsKt.encodeToByteArray((String)TwilsockMessageKt.encode($this$encodeToByteArray));
        }
        return byArray;
    }

    @NotNull
    public static final String encode(@NotNull TwilsockMessage $this$encode) {
        Intrinsics.checkNotNullParameter((Object)$this$encode, (String)"<this>");
        Object object = StringsKt.encodeToByteArray((String)$this$encode.getPayload()).length;
        int n = ((Number)object).intValue();
        String string = $this$encode.getRequestId();
        TwilsockMessage.Method method = $this$encode.getMethod();
        boolean bl = false;
        boolean bl2 = ((CharSequence)$this$encode.getPayload()).length() > 0;
        Object object2 = bl2 ? object : null;
        Object it = object = $this$encode.getPayloadType();
        Integer n2 = object2;
        boolean bl3 = false;
        boolean bl4 = ((CharSequence)$this$encode.getPayload()).length() > 0;
        Object object3 = bl4 ? object : null;
        Integer n3 = n2;
        String string2 = string;
        TwilsockMessage.Method method2 = method;
        TwilsockMessage.Headers headersToAdd = new TwilsockMessage.Headers(method2, string2, n3, (String)object3);
        Json $this$encodeToJsonElement$iv = InternalUtilsKt.getJson();
        boolean $i$f$encodeToJsonElement = false;
        $this$encodeToJsonElement$iv.getSerializersModule();
        JsonObject headerJson = new JsonObject(MapsKt.plus((Map)((Map)JsonElementKt.getJsonObject((JsonElement)$this$encodeToJsonElement$iv.encodeToJsonElement((SerializationStrategy)TwilsockMessage.Headers.Companion.serializer(), (Object)headersToAdd))), (Map)((Map)$this$encode.getHeaders())));
        String header = headerJson.toString();
        int headerSize = StringsKt.encodeToByteArray((String)header).length;
        String postfix = ((CharSequence)$this$encode.getPayload()).length() == 0 ? "" : "\r\n";
        return "TWILSOCK V3.0 " + headerSize + "\r\n" + header + "\r\n" + $this$encode.getPayload() + postfix;
    }

    @NotNull
    public static final TwilsockMessage parse(@NotNull TwilsockMessage.Companion $this$parse, @NotNull String message) throws Throwable {
        TwilsockMessage twilsockMessage;
        Intrinsics.checkNotNullParameter((Object)$this$parse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!StringsKt.startsWith$default((String)message, (String)TWILSOCK_PREFIX, (boolean)false, (int)2, null)) {
            boolean $i$a$-require-TwilsockMessageKt$parse$32 = false;
            String $i$a$-require-TwilsockMessageKt$parse$32 = "Invalid twilsock prefix";
            throw new IllegalArgumentException($i$a$-require-TwilsockMessageKt$parse$32.toString());
        }
        String[] $i$a$-require-TwilsockMessageKt$parse$32 = new String[]{"\r\n"};
        List list = StringsKt.split$default((CharSequence)message, (String[])$i$a$-require-TwilsockMessageKt$parse$32, (boolean)false, (int)0, (int)6, null);
        String prefix = (String)list.get(0);
        String header = (String)list.get(1);
        String payload = (String)list.get(2);
        char[] cArray = new char[]{' '};
        String headerSize = (String)StringsKt.split$default((CharSequence)prefix, (char[])cArray, (boolean)false, (int)0, (int)6, null).get(2);
        if (!(header.length() == Integer.parseInt(headerSize))) {
            boolean $i$a$-require-TwilsockMessageKt$parse$42 = false;
            String $i$a$-require-TwilsockMessageKt$parse$42 = "Invalid header size: expected = " + headerSize + "; actual = " + header.length();
            throw new IllegalArgumentException($i$a$-require-TwilsockMessageKt$parse$42.toString());
        }
        JsonObject headersJson = JsonElementKt.getJsonObject((JsonElement)InternalUtilsKt.getJson().parseToJsonElement(header));
        Json $this$decodeFromJsonElement$iv = InternalUtilsKt.getJson();
        boolean $i$f$decodeFromJsonElement = false;
        $this$decodeFromJsonElement$iv.getSerializersModule();
        TwilsockMessage.Headers headers = (TwilsockMessage.Headers)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)TwilsockMessage.Headers.Companion.serializer(), (JsonElement)headersJson);
        String string = headers.getPayloadType();
        if (string == null) {
            string = "";
        }
        String payloadType = string;
        switch (WhenMappings.$EnumSwitchMapping$0[headers.getMethod().ordinal()]) {
            case 1: {
                twilsockMessage = new TwilsockReplyMessage(headers.getRequestId(), header, headersJson, payloadType, payload);
                break;
            }
            case 2: {
                twilsockMessage = new TwilsockCloseMessage(headers.getRequestId(), header, headersJson, payloadType, payload);
                break;
            }
            case 3: {
                twilsockMessage = new TwilsockClientUpdateMessage(headers.getRequestId(), header, headersJson, payloadType, payload);
                break;
            }
            case 4: {
                twilsockMessage = new TwilsockNotificationMessage(headers.getRequestId(), header, headersJson, payloadType, payload);
                break;
            }
            case 5: {
                twilsockMessage = new TwilsockPingMessage(headers.getRequestId(), header, headersJson, payloadType, payload);
                break;
            }
            default: {
                twilsockMessage = new TwilsockMessage(headers.getRequestId(), headers.getMethod(), header, headersJson, payloadType, payload, null, 64, null);
            }
        }
        return twilsockMessage;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TwilsockMessage.Method.values().length];
            try {
                nArray[TwilsockMessage.Method.REPLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TwilsockMessage.Method.CLOSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TwilsockMessage.Method.CLIENT_UPDATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TwilsockMessage.Method.NOTIFICATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TwilsockMessage.Method.PING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

