/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.Preconditions;
import com.twilio.video.VideoCodec;
import java.util.List;

@VisibleForTesting(otherwise=5)
class MediaOptions {
    @Nullable
    private final List<VideoCodec> fakeVideoCodecs;
    @Nullable
    private final String audioFilePath;

    private MediaOptions(Builder builder) {
        this.fakeVideoCodecs = builder.fakeVideoCodecs;
        this.audioFilePath = builder.audioFilePath;
    }

    static class Builder {
        @Nullable
        private List<VideoCodec> fakeVideoCodecs;
        @Nullable
        private String audioFilePath;

        Builder() {
        }

        Builder fakeVideoCodecs(@Nullable List<VideoCodec> fakeVideoCodecs) {
            this.fakeVideoCodecs = fakeVideoCodecs;
            return this;
        }

        Builder audioFilePath(@NonNull String audioFilePath) {
            Preconditions.checkNotNull("audioFilePath should not be null", audioFilePath);
            this.audioFilePath = audioFilePath;
            return this;
        }

        MediaOptions build() {
            return new MediaOptions(this);
        }
    }
}

