/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.video.BandwidthProfileMode;
import com.twilio.video.Preconditions;
import com.twilio.video.TrackPriority;
import com.twilio.video.TrackSwitchOffMode;
import com.twilio.video.VideoDimensions;
import java.util.Collections;
import java.util.Map;

public class VideoBandwidthProfileOptions {
    @Nullable
    private final TrackPriority dominantSpeakerPriority;
    @Nullable
    private final Long maxSubscriptionBitrate;
    @Nullable
    private final Long maxTracks;
    @Nullable
    private final BandwidthProfileMode mode;
    @NonNull
    private final Map<TrackPriority, VideoDimensions> renderDimensions;
    @Nullable
    private final TrackSwitchOffMode trackSwitchOffMode;

    @Nullable
    public TrackPriority getDominantSpeakerPriority() {
        return this.dominantSpeakerPriority;
    }

    @Nullable
    public Long getMaxSubscriptionBitrate() {
        return this.maxSubscriptionBitrate;
    }

    @Nullable
    public Long getMaxTracks() {
        return this.maxTracks;
    }

    @Nullable
    public BandwidthProfileMode getMode() {
        return this.mode;
    }

    @NonNull
    public Map<TrackPriority, VideoDimensions> getRenderDimensions() {
        return this.renderDimensions;
    }

    @Nullable
    public TrackSwitchOffMode getTrackSwitchOffMode() {
        return this.trackSwitchOffMode;
    }

    private VideoBandwidthProfileOptions(Builder builder) {
        this.dominantSpeakerPriority = builder.dominantSpeakerPriority;
        this.maxSubscriptionBitrate = builder.maxSubscriptionBitrate;
        this.maxTracks = builder.maxTracks;
        this.mode = builder.mode;
        this.renderDimensions = builder.renderDimensions;
        this.trackSwitchOffMode = builder.trackSwitchOffMode;
    }

    public static class Builder {
        @Nullable
        private TrackPriority dominantSpeakerPriority;
        @Nullable
        private Long maxSubscriptionBitrate = 2400L;
        @Nullable
        private Long maxTracks;
        @Nullable
        private BandwidthProfileMode mode;
        private Map<TrackPriority, VideoDimensions> renderDimensions = Collections.emptyMap();
        @Nullable
        private TrackSwitchOffMode trackSwitchOffMode;

        public Builder dominantSpeakerPriority(@Nullable TrackPriority priority) {
            this.dominantSpeakerPriority = priority;
            return this;
        }

        public Builder maxSubscriptionBitrate(@Nullable Long maxSubscriptionBitrate) {
            this.maxSubscriptionBitrate = maxSubscriptionBitrate;
            return this;
        }

        public Builder maxTracks(@Nullable Long maxTracks) {
            this.maxTracks = maxTracks;
            return this;
        }

        public Builder mode(@Nullable BandwidthProfileMode mode) {
            this.mode = mode;
            return this;
        }

        public Builder renderDimensions(@NonNull Map<TrackPriority, VideoDimensions> dimensions) {
            Preconditions.checkNotNull(dimensions, "render dimensions must not be null");
            Preconditions.checkArgument(!dimensions.containsKey(null), "render dimensions cannot contain a null track priority key");
            Preconditions.checkArgument(!dimensions.containsValue(null), "render dimensions cannot contain a null video dimensions value");
            this.renderDimensions = dimensions;
            return this;
        }

        public Builder trackSwitchOffMode(@Nullable TrackSwitchOffMode mode) {
            this.trackSwitchOffMode = mode;
            return this;
        }

        public VideoBandwidthProfileOptions build() {
            return new VideoBandwidthProfileOptions(this);
        }
    }
}

