package com.twilio.video;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;

/** AudioSink consumes raw audio content from a AudioTrack. */
public interface AudioSink {

    /**
     * Render a single audio sample.
     *
     * @param audioSample A ByteBuffer which is being delivered to the sink.
     */
    void renderSample(@NonNull ByteBuffer audioSample, int encoding, int sampleRate, int channels);
}
