package com.twilio.video;

import androidx.annotation.NonNull;

public class RemoteAudioTrackStats extends RemoteTrackStats {
    /** Audio output level */
    public final int audioLevel;

    /** Packet jitter measured in milliseconds */
    public final int jitter;

    RemoteAudioTrackStats(
            @NonNull String trackSid,
            int packetsLost,
            @NonNull String codec,
            @NonNull String ssrc,
            double timestamp,
            long bytesReceived,
            int packetsReceived,
            int audioLevel,
            int jitter) {
        super(trackSid, packetsLost, codec, ssrc, timestamp, bytesReceived, packetsReceived);
        this.audioLevel = audioLevel;
        this.jitter = jitter;
    }
}
