/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import androidx.annotation.Nullable;
import java.util.List;
import tvi.webrtc.Logging;
import tvi.webrtc.VideoCodecInfo;
import tvi.webrtc.VideoEncoder;
import tvi.webrtc.VideoEncoderFactory;
import tvi.webrtc.WrappedNativeVideoEncoder;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "SoftwareVideoEncoderFactory";
    private final long nativeFactory = SoftwareVideoEncoderFactory.nativeCreateFactory();

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        final long nativeEncoder = SoftwareVideoEncoderFactory.nativeCreateEncoder(this.nativeFactory, info);
        if (nativeEncoder == 0L) {
            Logging.w(TAG, "Trying to create encoder for unsupported format. " + info);
            return null;
        }
        return new WrappedNativeVideoEncoder(){

            @Override
            public long createNativeVideoEncoder() {
                return nativeEncoder;
            }

            @Override
            public boolean isHardwareEncoder() {
                return false;
            }
        };
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoEncoderFactory.nativeGetSupportedCodecs(this.nativeFactory).toArray(new VideoCodecInfo[0]);
    }

    private static native long nativeCreateFactory();

    private static native long nativeCreateEncoder(long var0, VideoCodecInfo var2);

    private static native List<VideoCodecInfo> nativeGetSupportedCodecs(long var0);
}

