/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.support.annotation.NonNull;
import com.twilio.voice.AudioCodec;
import com.twilio.voice.Call;
import com.twilio.voice.CallInvite;
import com.twilio.voice.CallOptions;
import com.twilio.voice.IceOptions;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.PlatformInfo;
import com.twilio.voice.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AcceptOptions
extends CallOptions {
    private final Map<String, String> callInviteMessage;
    private final boolean reject;

    private AcceptOptions() {
        this.callInviteMessage = null;
        this.reject = false;
    }

    private AcceptOptions(Builder builder) {
        this.audioTracks = builder.audioTracks != null ? builder.audioTracks : new ArrayList();
        this.iceOptions = builder.iceOptions;
        this.enableInsights = builder.enableInsights;
        this.preferredAudioCodecs = builder.preferredAudioCodecs;
        this.callInviteMessage = builder.callInvite == null ? new HashMap() : ((Builder)builder).callInvite.callInviteMessage;
        this.platformInfo = new PlatformInfo();
        this.region = builder.region;
        this.reject = builder.reject;
        this.eventListener = builder.eventListener;
    }

    private long createNativeAcceptOptionsBuilder() {
        AcceptOptions.checkAudioTracksReleased(this.audioTracks);
        String accessToken = null;
        String[] keys = new String[]{};
        String[] values = new String[]{};
        String[] callInviteMessageKeys = new String[this.callInviteMessage.size()];
        String[] callInviteMessageValues = new String[this.callInviteMessage.size()];
        int index = 0;
        for (Map.Entry<String, String> mapEntry : this.callInviteMessage.entrySet()) {
            callInviteMessageKeys[index] = mapEntry.getKey();
            callInviteMessageValues[index] = mapEntry.getValue();
            ++index;
        }
        return this.nativeCreate(accessToken, keys, values, this.getLocalAudioTracksArray(), this.iceOptions, this.enableInsights, this.getAudioCodecsArray(), callInviteMessageKeys, callInviteMessageValues, this.reject, this.platformInfo, this.region);
    }

    private native long nativeCreate(String var1, String[] var2, String[] var3, LocalAudioTrack[] var4, IceOptions var5, boolean var6, AudioCodec[] var7, String[] var8, String[] var9, boolean var10, PlatformInfo var11, String var12);

    public static class Builder
    extends CallOptions.Builder {
        private final CallInvite callInvite;
        private final boolean reject;

        public Builder() {
            this.callInvite = null;
            this.reject = false;
        }

        Builder(@NonNull CallInvite callInvite, boolean reject) {
            Preconditions.checkNotNull(callInvite);
            this.callInvite = callInvite;
            this.reject = reject;
        }

        @Override
        @NonNull
        Builder audioTracks(@NonNull List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "audioTracks must not be null");
            super.audioTracks(audioTracks);
            return this;
        }

        @Override
        @NonNull
        public Builder iceOptions(@NonNull IceOptions iceOptions) {
            Preconditions.checkNotNull(iceOptions, "iceOptions must not be null");
            super.iceOptions(iceOptions);
            return this;
        }

        @Override
        @NonNull
        public Builder enableInsights(@NonNull boolean enable) {
            super.enableInsights(enable);
            return this;
        }

        @Override
        @NonNull
        public Builder preferAudioCodecs(@NonNull List<AudioCodec> preferredAudioCodecs) {
            Preconditions.checkNotNull(preferredAudioCodecs, "preferredAudioCodecs must not be null");
            CallOptions.checkAudioCodecs(preferredAudioCodecs);
            super.preferAudioCodecs(preferredAudioCodecs);
            return this;
        }

        @Override
        @NonNull
        public Builder region(@NonNull String region) {
            Preconditions.checkNotNull(region, "region must not be null");
            super.region(region);
            return this;
        }

        @Override
        Builder eventListener(Call.EventListener eventListener) {
            super.eventListener(eventListener);
            return this;
        }

        @NonNull
        public AcceptOptions build() {
            CallOptions.checkAudioTracksReleased(this.audioTracks);
            return new AcceptOptions(this);
        }
    }
}

