/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

class AudioOptions {
    public final boolean echoCancellation;
    public final boolean autoGainControl;
    public final boolean noiseSuppression;
    public final boolean highpassFilter;
    public final boolean stereoSwapping;
    public final boolean audioJitterBufferFastAccelerate;
    public final boolean typingDetection;

    private AudioOptions(Builder builder) {
        this.echoCancellation = builder.echoCancellation;
        this.autoGainControl = builder.autoGainControl;
        this.noiseSuppression = builder.noiseSuppression;
        this.highpassFilter = builder.highpassFilter;
        this.stereoSwapping = builder.stereoSwapping;
        this.audioJitterBufferFastAccelerate = builder.audioJitterBufferFastAccelerate;
        this.typingDetection = builder.typingDetection;
    }

    public String toString() {
        return "AudioOptions{echoCancellation=" + this.echoCancellation + ", autoGainControl=" + this.autoGainControl + ", noiseSuppression=" + this.noiseSuppression + ", highpassFilter=" + this.highpassFilter + ", stereoSwapping=" + this.stereoSwapping + ", audioJitterBufferFastAccelerate=" + this.audioJitterBufferFastAccelerate + ", typingDetection=" + this.typingDetection + '}';
    }

    public static final class Builder {
        private boolean echoCancellation;
        private boolean autoGainControl;
        private boolean noiseSuppression;
        private boolean highpassFilter;
        private boolean stereoSwapping;
        private boolean audioJitterBufferFastAccelerate;
        private boolean typingDetection;

        public Builder echoCancellation(boolean echoCancellation) {
            this.echoCancellation = echoCancellation;
            return this;
        }

        public Builder autoGainControl(boolean autoGainControl) {
            this.autoGainControl = autoGainControl;
            return this;
        }

        public Builder noiseSuppression(boolean noiseSuppression) {
            this.noiseSuppression = noiseSuppression;
            return this;
        }

        public Builder highpassFilter(boolean highpassFilter) {
            this.highpassFilter = highpassFilter;
            return this;
        }

        public Builder stereoSwapping(boolean stereoSwapping) {
            this.stereoSwapping = stereoSwapping;
            return this;
        }

        public Builder audioJitterBufferFastAccelerate(boolean audioJitterBufferFastAccelerate) {
            this.audioJitterBufferFastAccelerate = audioJitterBufferFastAccelerate;
            return this;
        }

        public Builder typingDetection(boolean typingDetection) {
            this.typingDetection = typingDetection;
            return this;
        }

        public AudioOptions build() {
            return new AudioOptions(this);
        }
    }
}

