/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import com.twilio.voice.AcceptOptions;
import com.twilio.voice.CallException;
import com.twilio.voice.CallInvite;
import com.twilio.voice.ConnectOptions;
import com.twilio.voice.ConnectivityReceiver;
import com.twilio.voice.Constants;
import com.twilio.voice.EventGroupType;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.InternalCall;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.Logger;
import com.twilio.voice.MediaFactory;
import com.twilio.voice.Preconditions;
import com.twilio.voice.RTCMonitor;
import com.twilio.voice.RTCStatsSample;
import com.twilio.voice.StatsListener;
import com.twilio.voice.StatsReport;
import com.twilio.voice.ThreadUtils;
import com.twilio.voice.Utils;
import com.twilio.voice.Voice;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Call
extends InternalCall {
    private final ThreadUtils.ThreadChecker threadChecker;
    private Listener listener;
    private EventListener eventListener;
    private static final Logger logger = Logger.getLogger(Call.class);
    private List<LocalAudioTrack> localAudioTracks;
    private MediaFactory mediaFactory;
    private long nativeCallDelegate;
    private Queue<Pair<Handler, StatsListener>> statsListenersQueue;
    private ConnectivityReceiver connectivityReceiver = null;
    private final Listener callListenerProxy = new Listener(){

        @Override
        public void onRinging(final @NonNull Call call) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onRinging()");
                    Call.this.state = State.RINGING;
                    call.sid = Call.this.nativeGetSid(Call.this.nativeCallDelegate);
                    Call.this.listener.onRinging(call);
                }
            });
        }

        @Override
        public void onConnected(final @NonNull Call call) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onConnected()");
                    Call.this.state = State.CONNECTED;
                    call.sid = Call.this.nativeGetSid(Call.this.nativeCallDelegate);
                    Call.this.listener.onConnected(call);
                }
            });
        }

        @Override
        public void onConnectFailure(final @NonNull Call call, final @NonNull CallException callException) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.releaseCall();
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onConnectFailure()");
                    Call.this.unregisterConnectivityBroadcastReceiver(Call.this.context);
                    Voice.calls.remove(Call.this);
                    Voice.rejects.remove(Call.this);
                    Call.this.state = State.DISCONNECTED;
                    Call.this.release();
                    Call.this.listener.onConnectFailure(call, callException);
                }
            });
        }

        @Override
        public void onDisconnected(final @NonNull Call call, final CallException callException) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.releaseCall();
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onDisconnected()");
                    Call.this.unregisterConnectivityBroadcastReceiver(Call.this.context);
                    Voice.calls.remove(Call.this);
                    Voice.rejects.remove(Call.this);
                    Call.this.state = State.DISCONNECTED;
                    Call.this.release();
                    Call.this.listener.onDisconnected(call, callException);
                }
            });
        }
    };
    EventListener eventListenerProxy = new EventListener(){

        @Override
        public void onEvent(final HashMap<String, String> data) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (Call.this.eventListener != null) {
                        Call.this.eventListener.onEvent(data);
                    }
                    if (((String)data.get("group")).equals("ice-gathering-state")) {
                        Call.this.publishIceGatheringEvent((String)data.get("name"));
                    } else if (((String)data.get("group")).equals("ice-connection-state")) {
                        Call.this.publishIceConnectionEvent((String)data.get("name"));
                    } else if (((String)data.get("group")).equals("connection")) {
                        if (((String)data.get("name")).equals("error")) {
                            if (data.get("error_code") != null) {
                                Call.this.publishConnectionErrorEvent((String)data.get("name"), Integer.parseInt((String)data.get("error_code")), (String)data.get("error_message"));
                            }
                        } else {
                            Call.this.publishConnectionEvent((String)data.get("name"));
                        }
                    } else if (((String)data.get("group")).equals("signaling-state")) {
                        Call.this.publishSignalingStateEvent((String)data.get("name"));
                    } else if (((String)data.get("group")).equals(EventGroupType.EDGE_GROUP)) {
                        Call.this.gateway = (String)data.get("edge-host-name");
                        Call.this.region = (String)data.get("edge-host-region");
                    }
                }
            });
        }

        @Override
        public void onMetric(HashMap<String, String> data) {
            if (Call.this.eventListener != null) {
                Call.this.eventListener.onMetric(data);
            }
            if (data.get("group").equals("quality-metrics-samples")) {
                RTCStatsSample rtcStatsSample = new RTCStatsSample();
                rtcStatsSample.packetsReceived = Integer.parseInt(data.get("packets_received"));
                rtcStatsSample.totalPacketsLost = Integer.parseInt(data.get("total_packets_lost"));
                rtcStatsSample.fractionLost = Double.parseDouble(data.get("packets_lost_fraction"));
                rtcStatsSample.totalPacketsSent = Integer.parseInt(data.get("total_packets_sent"));
                rtcStatsSample.totalPacketsReceived = Integer.parseInt(data.get("total_packets_received"));
                rtcStatsSample.totalBytesReceived = Long.parseLong(data.get("total_bytes_received"));
                rtcStatsSample.totalBytesSent = Long.parseLong(data.get("total_bytes_sent"));
                rtcStatsSample.jitter = Integer.parseInt(data.get("jitter"));
                rtcStatsSample.rtt = Integer.parseInt(data.get("rtt"));
                rtcStatsSample.audioInputLevel = Integer.parseInt(data.get("audio_level_in"));
                rtcStatsSample.audioOutputLevel = Integer.parseInt(data.get("audio_level_out"));
                rtcStatsSample.mos = Double.parseDouble(data.get("mos"));
                rtcStatsSample.codec = data.get("audio_codec");
                rtcStatsSample.timestampMS = (long)Double.parseDouble(data.get("timestamp_ms"));
                TimeZone tz = TimeZone.getTimeZone("UTC");
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                df.setTimeZone(tz);
                Date now = new Date(rtcStatsSample.timestampMS);
                rtcStatsSample.timeStamp = df.format(now);
                Call.this.onSample(rtcStatsSample);
            }
        }
    };
    private final StatsListener statsListenerProxy = new StatsListener(){

        @Override
        public void onStats(final List<StatsReport> statsReports) {
            final Pair statsPair = (Pair)Call.this.statsListenersQueue.poll();
            if (statsPair != null) {
                ((Handler)statsPair.first).post(new Runnable(){

                    @Override
                    public void run() {
                        ((StatsListener)statsPair.second).onStats(statsReports);
                    }
                });
            }
        }
    };

    Call(Context context, CallInvite callInvite, Listener listener) {
        Preconditions.checkApplicationContext(context, "must create Call with application context");
        this.context = context;
        this.listener = listener;
        this.from = callInvite.getFrom();
        this.to = callInvite.getTo();
        this.sid = callInvite.getCallSid();
        this.bridgeToken = callInvite.getBridgeToken();
        this.disconnectCalled = false;
        this.direction = Constants.Direction.INCOMING;
        this.handler = Utils.createHandler();
        this.threadChecker = new ThreadUtils.ThreadChecker(this.handler.getLooper().getThread());
        this.state = State.CONNECTING;
        this.publisher = new EventPublisher("twilio-voice-android", this.bridgeToken);
        this.publisher.addListener(this);
        this.rtcMonitor = new RTCMonitor();
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
    }

    Call(Context context, String accessToken, Listener listener) {
        Preconditions.checkApplicationContext(context, "must create Call with application context");
        this.context = context;
        this.listener = listener;
        this.state = State.CONNECTING;
        this.direction = Constants.Direction.OUTGOING;
        this.handler = Utils.createHandler();
        this.threadChecker = new ThreadUtils.ThreadChecker(this.handler.getLooper().getThread());
        this.publisher = new EventPublisher("twilio-voice-android", accessToken);
        this.publisher.addListener(this);
        this.rtcMonitor = new RTCMonitor();
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
    }

    @Nullable
    public String getFrom() {
        return this.from;
    }

    @Nullable
    public String getTo() {
        return this.to;
    }

    @Override
    @Nullable
    public String getSid() {
        return this.sid;
    }

    @Override
    @NonNull
    public State getState() {
        return this.state;
    }

    public synchronized void getStats(@NonNull StatsListener statsListener) {
        this.threadChecker.checkIsOnValidThread();
        Preconditions.checkNotNull(statsListener, "statsListener must not be null");
        if (this.state == State.DISCONNECTED) {
            return;
        }
        this.statsListenersQueue.offer((Pair<Handler, StatsListener>)new Pair((Object)Utils.createHandler(), (Object)statsListener));
        this.nativeGetStats(this.nativeCallDelegate);
    }

    public void postFeedback(@NonNull Score score, @NonNull Issue issue) {
        Preconditions.checkNotNull(score, "score must not be null");
        Preconditions.checkNotNull(issue, "issue must not be null");
        this.publishFeedbackEvent(score, issue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(ConnectOptions connectOptions) {
        this.threadChecker.checkIsOnValidThread();
        this.registerConnectivityBroadcastReceiver(this.context);
        Voice.calls.add(this);
        ConnectOptions.checkAudioTracksReleased(connectOptions.getAudioTracks());
        this.localAudioTracks = connectOptions.getAudioTracks();
        this.selectedRegion = connectOptions.getRegion();
        Listener listener = this.callListenerProxy;
        synchronized (listener) {
            Voice.loadLibrary(this.context);
            this.mediaFactory = MediaFactory.instance(this, this.context);
            if (connectOptions.getEventListener() != null) {
                this.eventListener = connectOptions.getEventListener();
            }
            this.nativeCallDelegate = this.nativeConnect(connectOptions, this.callListenerProxy, this.statsListenerProxy, this.eventListenerProxy, this.mediaFactory.getNativeMediaFactoryHandle(), this.handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(AcceptOptions acceptOptions) {
        this.threadChecker.checkIsOnValidThread();
        this.registerConnectivityBroadcastReceiver(this.context);
        Voice.calls.add(this);
        AcceptOptions.checkAudioTracksReleased(acceptOptions.getAudioTracks());
        this.localAudioTracks = acceptOptions.getAudioTracks();
        this.selectedRegion = acceptOptions.getRegion();
        Listener listener = this.callListenerProxy;
        synchronized (listener) {
            Voice.loadLibrary(this.context);
            this.mediaFactory = MediaFactory.instance(this, this.context);
            if (acceptOptions.getEventListener() != null) {
                this.eventListener = acceptOptions.getEventListener();
            }
            this.nativeCallDelegate = this.nativeAccept(acceptOptions, this.callListenerProxy, this.statsListenerProxy, this.eventListenerProxy, this.mediaFactory.getNativeMediaFactoryHandle(), this.handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reject(AcceptOptions acceptOptions) {
        this.threadChecker.checkIsOnValidThread();
        this.registerConnectivityBroadcastReceiver(this.context);
        Voice.rejects.add(this);
        this.localAudioTracks = acceptOptions.getAudioTracks();
        this.selectedRegion = acceptOptions.getRegion();
        Listener listener = this.callListenerProxy;
        synchronized (listener) {
            Voice.loadLibrary(this.context);
            if (acceptOptions.getEventListener() != null) {
                this.eventListener = acceptOptions.getEventListener();
            }
            this.nativeCallDelegate = this.nativeReject(acceptOptions, this.callListenerProxy, this.eventListenerProxy, this.handler);
        }
    }

    @Override
    public synchronized void mute(boolean mute) {
        this.threadChecker.checkIsOnValidThread();
        if (this.isValidState()) {
            this.isMuted = mute;
            this.nativeMute(this.nativeCallDelegate, mute);
        }
    }

    @Override
    public synchronized void sendDigits(@NonNull String digits) {
        this.threadChecker.checkIsOnValidThread();
        Preconditions.checkNotNull(digits, "digits must not be null");
        if (!digits.matches("^[0-9\\*\\#w]+$")) {
            throw new IllegalArgumentException("digits string must not be null and should only contains 0-9, *, #, or w characters");
        }
        if (this.isValidState()) {
            this.nativeSendDigits(this.nativeCallDelegate, digits);
        }
    }

    public synchronized void hold(boolean hold) {
        this.threadChecker.checkIsOnValidThread();
        if (this.isValidState()) {
            this.isOnHold = hold;
            this.nativeHold(this.nativeCallDelegate, hold);
        }
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    public boolean isOnHold() {
        return this.isOnHold;
    }

    @Override
    public synchronized void disconnect() {
        this.threadChecker.checkIsOnValidThread();
        if (!this.disconnectCalled && this.isValidState()) {
            this.disconnectCalled = true;
            logger.d("Calling disconnect " + (Object)((Object)this.state));
            this.nativeDisconnect(this.nativeCallDelegate);
        }
    }

    void networkChange(Voice.NetworkChangeEvent networkChangeEvent) {
        this.threadChecker.checkIsOnValidThread();
        if (this.isValidState() && this.isPermittedNetworkChangeEvent(networkChangeEvent)) {
            this.nativeNetworkChange(this.nativeCallDelegate, networkChangeEvent);
        } else {
            logger.d("Ignoring networkChangeEvent: " + networkChangeEvent.name() + " in Call.State: " + (Object)((Object)this.state));
        }
    }

    synchronized void release() {
        this.threadChecker.checkIsOnValidThread();
        for (LocalAudioTrack localAudioTrack : this.localAudioTracks) {
            localAudioTrack.release();
        }
        if (this.nativeCallDelegate != 0L) {
            this.nativeRelease(this.nativeCallDelegate);
            this.nativeCallDelegate = 0L;
            if (this.mediaFactory != null) {
                this.mediaFactory.release(this);
            }
        }
    }

    private void registerConnectivityBroadcastReceiver(Context context) {
        this.connectivityReceiver = new ConnectivityReceiver();
        context.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private boolean isPermittedNetworkChangeEvent(Voice.NetworkChangeEvent networkChangeEvent) {
        return networkChangeEvent != Voice.NetworkChangeEvent.CONNECTION_CHANGED || this.state != State.CONNECTING && this.state != State.RINGING;
    }

    private void unregisterConnectivityBroadcastReceiver(Context context) {
        context.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
        this.connectivityReceiver = null;
    }

    private synchronized void releaseCall() {
        if (this.nativeCallDelegate != 0L) {
            this.nativeReleaseCall(this.nativeCallDelegate);
        }
    }

    private native long nativeConnect(ConnectOptions var1, Listener var2, StatsListener var3, EventListener var4, long var5, Handler var7);

    private native long nativeAccept(AcceptOptions var1, Listener var2, StatsListener var3, EventListener var4, long var5, Handler var7);

    private native long nativeReject(AcceptOptions var1, Listener var2, EventListener var3, Handler var4);

    private native String nativeGetSid(long var1);

    private native void nativeGetStats(long var1);

    private native void nativeMute(long var1, boolean var3);

    private native void nativeSendDigits(long var1, String var3);

    private native void nativeHold(long var1, boolean var3);

    private native void nativeDisconnect(long var1);

    private native void nativeNetworkChange(long var1, Voice.NetworkChangeEvent var3);

    private native void nativeReleaseCall(long var1);

    private native void nativeRelease(long var1);

    static interface EventListener {
        public void onEvent(HashMap<String, String> var1);

        public void onMetric(HashMap<String, String> var1);
    }

    public static interface Listener {
        public void onConnectFailure(@NonNull Call var1, @NonNull CallException var2);

        public void onRinging(@NonNull Call var1);

        public void onConnected(@NonNull Call var1);

        public void onDisconnected(@NonNull Call var1, @Nullable CallException var2);
    }

    public static enum State {
        CONNECTING,
        RINGING,
        CONNECTED,
        DISCONNECTED;

    }

    public static enum Issue {
        NOT_REPORTED("not-reported"),
        DROPPED_CALL("dropped-call"),
        AUDIO_LATENCY("audio-latency"),
        ONE_WAY_AUDIO("one-way-audio"),
        CHOPPY_AUDIO("choppy-audio"),
        NOISY_CALL("noisy-call"),
        ECHO("echo");

        private final String issueName;

        private Issue(String issueName) {
            this.issueName = issueName;
        }

        public String toString() {
            return this.issueName;
        }
    }

    public static enum Score {
        NOT_REPORTED(0),
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5);

        private final int score;

        private Score(int score) {
            this.score = score;
        }

        public int getValue() {
            return this.score;
        }
    }
}

