/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.twilio.voice.AcceptOptions;
import com.twilio.voice.Call;
import com.twilio.voice.CallException;
import com.twilio.voice.Constants;
import com.twilio.voice.EventPayload;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.InternalCall;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.Logger;
import com.twilio.voice.Preconditions;
import com.twilio.voice.Utils;
import com.twilio.voice.VoiceException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class CallInvite
implements Parcelable {
    private static final Logger logger = Logger.getLogger(InternalCall.class);
    private final String bridgeToken;
    private final String callSid;
    private final String from;
    private final String to;
    private final EventPublisher publisher;
    final Map<String, String> callInviteMessage;
    final Map<String, String> customParameters;
    private final Call.Listener callListenerProxy = new Call.Listener(){

        @Override
        public void onRinging(@NonNull Call call) {
        }

        @Override
        public void onConnected(@NonNull Call call) {
        }

        @Override
        public void onConnectFailure(@NonNull Call call, @NonNull CallException callException) {
            call.release();
        }

        @Override
        public void onDisconnected(@NonNull Call call, CallException callException) {
            call.release();
        }
    };
    Call.EventListener eventListenerProxy = new Call.EventListener(){

        @Override
        public void onEvent(HashMap<String, String> data) {
        }

        @Override
        public void onMetric(HashMap<String, String> data) {
        }
    };
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public CallInvite createFromParcel(Parcel in) {
            return new CallInvite(in);
        }

        public CallInvite[] newArray(int size) {
            return new CallInvite[size];
        }
    };

    static CallInvite create(Map<String, String> data) {
        return new CallInvite(data);
    }

    private CallInvite(Map<String, String> data) {
        this.from = data.get("twi_from");
        this.to = data.get("twi_to");
        this.callSid = data.get("twi_call_sid");
        this.bridgeToken = data.get("twi_bridge_token");
        this.customParameters = new HashMap<String, String>();
        String query_pairs = data.get("twi_params");
        if (query_pairs != null) {
            String[] pairs;
            for (String pair : pairs = query_pairs.split("&")) {
                int idx = pair.indexOf("=");
                try {
                    String key = idx > 0 ? pair.substring(0, idx) : pair;
                    String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1).replaceAll("\\+", "%20"), "UTF-8") : null;
                    this.customParameters.put(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        this.callInviteMessage = data;
        this.publisher = new EventPublisher("twilio-voice-android", this.bridgeToken);
        this.publisher.addListener(new EventPublisher.EventPublisherListener(){

            @Override
            public void onError(VoiceException voiceException) {
                logger.e("Error publishing data : " + voiceException.getMessage() + ":" + voiceException.getErrorCode());
            }
        });
        this.publishConnectionEvent("incoming");
    }

    private CallInvite(Parcel in) {
        String[] data = new String[4];
        in.readStringArray(data);
        this.from = data[0];
        this.to = data[1];
        this.callSid = data[2];
        this.bridgeToken = data[3];
        int size = in.readInt();
        this.callInviteMessage = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.callInviteMessage.put(key, value);
        }
        int sizeOfCustomParams = in.readInt();
        this.customParameters = new HashMap<String, String>(sizeOfCustomParams);
        for (int i = 0; i < sizeOfCustomParams; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.customParameters.put(key, value);
        }
        this.publisher = null;
    }

    @Nullable
    public String getFrom() {
        return this.from;
    }

    @NonNull
    public String getTo() {
        return this.to;
    }

    @NonNull
    public String getCallSid() {
        return this.callSid;
    }

    @NonNull
    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    String getBridgeToken() {
        return this.bridgeToken;
    }

    @NonNull
    public synchronized Call accept(@NonNull Context context, @NonNull AcceptOptions acceptOptions, @NonNull Call.Listener listener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(acceptOptions, "acceptOptions must not be null");
        Preconditions.checkNotNull(listener, "listener must not be null");
        if (!Utils.isAudioPermissionGranted(context)) {
            throw new SecurityException("Requires the RECORD_AUDIO permission");
        }
        AcceptOptions.Builder acceptOptionsBuilder = new AcceptOptions.Builder(this, false);
        if (acceptOptions.getIceOptions() != null) {
            acceptOptionsBuilder.iceOptions(acceptOptions.getIceOptions());
        }
        if (acceptOptions.getRegion() != null) {
            acceptOptionsBuilder.region(acceptOptions.getRegion());
        }
        if (acceptOptions.getPreferredAudioCodecs() != null) {
            acceptOptionsBuilder.preferAudioCodecs((List)acceptOptions.getPreferredAudioCodecs());
        }
        acceptOptionsBuilder.enableInsights(acceptOptions.enableInsights);
        LocalAudioTrack localAudioTrack = LocalAudioTrack.create(context, true);
        acceptOptionsBuilder.audioTracks((List)Collections.singletonList(localAudioTrack));
        acceptOptionsBuilder.eventListener(acceptOptions.getEventListener());
        AcceptOptions internalAcceptOptions = acceptOptionsBuilder.build();
        Call call = new Call(context.getApplicationContext(), this, listener);
        call.accept(internalAcceptOptions);
        return call;
    }

    @NonNull
    public synchronized Call accept(@NonNull Context context, @NonNull Call.Listener listener) {
        return this.accept(context, new AcceptOptions.Builder().build(), listener);
    }

    public synchronized void reject(@NonNull Context context) {
        this.reject(context, this.callListenerProxy, this.eventListenerProxy);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringArray(new String[]{this.from, this.to, this.callSid, this.bridgeToken});
        dest.writeInt(this.callInviteMessage.size());
        for (Map.Entry<String, String> entry : this.callInviteMessage.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        if (this.customParameters != null) {
            dest.writeInt(this.customParameters.size());
            for (Map.Entry<String, String> entry : this.customParameters.entrySet()) {
                dest.writeString(entry.getKey());
                dest.writeString(entry.getValue());
            }
        }
    }

    @VisibleForTesting
    void reject(@NonNull Context context, @NonNull Call.Listener listener, @NonNull Call.EventListener eventListener) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(context, "listener must not be null");
        Preconditions.checkNotNull(context, "eventListener must not be null");
        AcceptOptions.Builder acceptOptionsBuilder = new AcceptOptions.Builder(this, true);
        AcceptOptions acceptOptions = acceptOptionsBuilder.eventListener(eventListener).build();
        Call call = new Call(context.getApplicationContext(), this, listener);
        call.reject(acceptOptions);
    }

    static boolean isValid(Map<String, String> data) {
        String messageType = data.get("twi_message_type");
        String bridgeToken = data.get("twi_bridge_token");
        String callSid = data.get("twi_call_sid");
        String to = data.get("twi_to");
        return messageType != null && messageType.equals("twilio.voice.call") && bridgeToken != null && callSid != null && to != null;
    }

    public boolean equals(Object o) {
        if (o instanceof CallInvite) {
            CallInvite callInvite = (CallInvite)o;
            return this.getFrom().equals(callInvite.getFrom()) && this.getTo().equals(callInvite.getTo()) && this.getCallSid().equals(callInvite.getCallSid());
        }
        return false;
    }

    void publishConnectionEvent(String eventName) {
        logger.d("Publishing event : " + eventName);
        EventPayload eventPayload = new EventPayload.Builder().callSid(this.callSid).direction(Constants.Direction.INCOMING).productName("twilio-voice-android").clientName(null).payLoadType("application/json").build();
        try {
            JSONObject connectionEventPayload = eventPayload.getPayload();
            if (this.publisher != null) {
                this.publisher.publish(Constants.SeverityLevel.INFO, "connection", eventName, connectionEventPayload);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

