/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.annotation.SuppressLint;
import com.twilio.voice.Constants;
import com.twilio.voice.EventMetadata;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONObject;

class Event
extends EventMetadata {
    private JSONObject payload;

    private Event(Builder builder) {
        this.productName = builder.productName;
        this.level = builder.level;
        this.groupName = builder.groupName;
        this.eventName = builder.eventName;
        this.payload = builder.payload;
        this.payloadType = builder.payloadType;
        this.timeStamp = builder.timeStamp;
        this.timestampMS = builder.timestampMS;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public JSONObject toJSONObject() throws Exception {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        this.timeStamp = df.format(new Date());
        JSONObject eventJsonObject = this.jsonEnvelopePreparation(this.productName, this.eventName, this.groupName);
        JSONObject publisherMetadata = this.jsonPublisherMetadataPreparation();
        eventJsonObject.put("publisher_metadata", (Object)publisherMetadata);
        eventJsonObject.put("payload_type", (Object)this.payloadType);
        eventJsonObject.put("payload", (Object)this.payload);
        return eventJsonObject;
    }

    public JSONObject getPayload() {
        return this.payload;
    }

    public static class Builder {
        private String productName;
        private Constants.SeverityLevel level;
        private String groupName;
        private String eventName;
        private JSONObject payload;
        private String payloadType;
        private long timestampMS;
        private String timeStamp;

        @SuppressLint(value={"SimpleDateFormat"})
        Builder() {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(tz);
            Date now = new Date();
            this.timeStamp = df.format(now);
            this.timestampMS = now.getTime();
        }

        Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        Builder level(Constants.SeverityLevel level) {
            this.level = level;
            return this;
        }

        Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        Builder payLoadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        Builder payLoad(JSONObject payload) {
            this.payload = payload;
            return this;
        }

        Event build() {
            if (this.productName == null) {
                throw new NullPointerException("productName must not be null");
            }
            if (this.level == null) {
                throw new NullPointerException("level must not be null");
            }
            if (this.groupName == null) {
                throw new NullPointerException("groupName must not be null");
            }
            if (this.eventName == null) {
                throw new NullPointerException("eventName must not be null");
            }
            if (this.payloadType == null) {
                throw new NullPointerException("payloadType must not be null");
            }
            return new Event(this);
        }
    }
}

