/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.os.Build;
import com.twilio.voice.Constants;
import com.twilio.voice.Utils;
import org.json.JSONException;
import org.json.JSONObject;

class EventMetadata {
    String timeStamp;
    String productName;
    Constants.SeverityLevel level;
    String groupName;
    String eventName;
    String callSid;
    String payloadType;
    long timestampMS;
    boolean isPrivate = false;

    EventMetadata() {
    }

    String getTimeStamp() {
        return this.timeStamp;
    }

    Object getPayloadType() {
        return this.payloadType;
    }

    String getProductName() {
        return this.productName;
    }

    Constants.SeverityLevel getLevel() {
        return this.level;
    }

    boolean isPrivate() {
        return this.isPrivate;
    }

    String getGroupName() {
        return this.groupName;
    }

    String getEventName() {
        return this.eventName;
    }

    String getCallSid() {
        return this.callSid;
    }

    long getTimestampMillis() {
        return this.timestampMS;
    }

    JSONObject jsonEnvelopePreparation(String productName, String eventName, String groupName) throws JSONException {
        JSONObject envelope = new JSONObject();
        envelope.put("name", (Object)this.eventName);
        envelope.put("group", (Object)this.groupName);
        envelope.put("timestamp", (Object)this.timeStamp);
        envelope.put("level", (Object)this.level);
        envelope.put("private", this.isPrivate);
        envelope.put("payload_type", (Object)this.payloadType);
        envelope.put("publisher", (Object)this.productName);
        return envelope;
    }

    JSONObject jsonPublisherMetadataPreparation() throws JSONException {
        JSONObject publisherMetadata = new JSONObject();
        publisherMetadata.put("client_address", (Object)Utils.getIPAddress(false));
        publisherMetadata.put("os_name", (Object)"android");
        publisherMetadata.put("os_version", (Object)Build.VERSION.RELEASE);
        publisherMetadata.put("device_model", (Object)Build.MODEL);
        publisherMetadata.put("device_vendor", (Object)Build.MANUFACTURER);
        publisherMetadata.put("device_type", (Object)Build.MODEL);
        publisherMetadata.put("cpu_architecture", (Object)Build.CPU_ABI);
        return publisherMetadata;
    }
}

