/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.annotation.SuppressLint;
import com.twilio.voice.Call;
import com.twilio.voice.Constants;
import com.twilio.voice.RTCStatsSample;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

class EventPayload {
    boolean isPrivate = false;
    private String timeStamp;
    private String productName;
    private String callSid;
    private String payloadType;
    private long timestampMS;
    private JSONObject payload;
    private String clientName;
    private Constants.Direction direction;
    private List<RTCStatsSample> sampleList;
    private String qualityParam;
    private int qualityThreshold;
    private int sampleValue;
    private String tempCallSid;
    private int qualityScore;
    private String issueName;
    private int errorCode;
    private String errorMessage;
    private String requestId;
    private String selectedRegion;
    private String gateway;
    private String region;

    private EventPayload(Builder builder) {
        this.productName = builder.productName;
        this.payload = builder.payload;
        this.payloadType = builder.payloadType;
        this.timeStamp = builder.timeStamp;
        this.timestampMS = builder.timestampMS;
        this.clientName = builder.clientName;
        this.direction = builder.direction;
        this.qualityParam = builder.qualityParam;
        this.qualityThreshold = builder.qualityThreshold;
        this.sampleValue = builder.sampleValue;
        this.sampleList = builder.sampleList;
        this.callSid = builder.callSid;
        this.tempCallSid = builder.tempCallSid;
        this.qualityScore = builder.qualityScore;
        this.issueName = builder.issue;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.requestId = builder.requestId;
        this.selectedRegion = builder.selectedRegion;
        this.gateway = builder.gateway;
        this.region = builder.region;
    }

    String getTimeStamp() {
        return this.timeStamp;
    }

    Object getPayloadType() {
        return this.payloadType;
    }

    String getProductName() {
        return this.productName;
    }

    boolean isPrivate() {
        return this.isPrivate;
    }

    String getCallSid() {
        return this.callSid;
    }

    long getTimestampMillis() {
        return this.timestampMS;
    }

    JSONObject getPayload() throws Exception {
        this.jsonPayloadPreparation();
        return this.payload;
    }

    String getClientName() {
        return this.clientName;
    }

    Constants.Direction getDirection() {
        return this.direction;
    }

    List<RTCStatsSample> getSampleList() {
        return this.sampleList;
    }

    String getQualityParam() {
        return this.qualityParam;
    }

    int getQualityThreshold() {
        return this.qualityThreshold;
    }

    int getSampleValue() {
        return this.sampleValue;
    }

    String getTempCallSid() {
        return this.tempCallSid;
    }

    int getQualityScore() {
        return this.qualityScore;
    }

    String getIssueName() {
        return this.issueName;
    }

    JSONObject jsonPayloadPreparation() throws Exception {
        JSONObject payload = new JSONObject();
        payload.put("timestamp_ms", this.timestampMS);
        payload.put("client_name", (Object)this.clientName);
        payload.put("temp_call_sid", (Object)this.tempCallSid);
        payload.put("call_sid", (Object)this.callSid);
        payload.put("sdk_version", (Object)"3.0.0-beta11");
        payload.put("platform", (Object)"android");
        payload.put("direction", (Object)this.direction);
        payload.put("selected_region", (Object)this.selectedRegion);
        payload.put("gateway", (Object)this.gateway);
        payload.put("region", (Object)this.region);
        if (this.errorCode > 0) {
            payload.put("code", this.errorCode);
            payload.put("message", (Object)this.errorMessage);
        }
        if (this.requestId != null) {
            payload.put("request_sid", (Object)this.requestId);
        }
        JSONObject data = new JSONObject();
        if (this.sampleList != null) {
            data.put("threshold", this.qualityThreshold);
            JSONArray values = new JSONArray();
            for (RTCStatsSample sample : this.sampleList) {
                if (sample == null) continue;
                int sampleValue = 0;
                if (this.qualityParam.compareTo("mos") == 0) {
                    sampleValue = (int)sample.getMosScore();
                } else if (this.qualityParam.compareTo("jitter") == 0) {
                    sampleValue = sample.getJitter();
                } else if (this.qualityParam.compareTo("rtt") == 0) {
                    sampleValue = sample.getRtt();
                } else if (this.qualityParam.compareTo("packetsLostFraction") == 0) {
                    sampleValue = (int)sample.getFractionLost();
                }
                values.put(sampleValue);
            }
            data.put("values", (Object)values);
        } else if (this.sampleValue >= 0) {
            data.put("threshold", this.qualityThreshold);
            data.put("value", this.sampleValue);
        } else {
            if (this.qualityScore > 0) {
                payload.put("quality_score", this.qualityScore);
            }
            if (this.issueName != null && !this.issueName.equals(Call.Issue.NOT_REPORTED.toString())) {
                payload.put("issue_name", (Object)this.issueName);
            }
            data = null;
        }
        payload.put("data", (Object)data);
        this.payload = payload;
        return this.payload;
    }

    static class Builder {
        private String productName;
        private JSONObject payload;
        private String payloadType;
        private long timestampMS;
        private String timeStamp;
        private String callSid;
        private String clientName;
        private Constants.Direction direction;
        private List<RTCStatsSample> sampleList;
        private String qualityParam;
        private int qualityThreshold;
        private int sampleValue = -1;
        private String tempCallSid;
        private int qualityScore;
        private String issue;
        private int errorCode;
        private String errorMessage;
        private String requestId;
        private String selectedRegion;
        private String gateway;
        private String region;

        @SuppressLint(value={"SimpleDateFormat"})
        Builder() {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(tz);
            Date now = new Date();
            this.timeStamp = df.format(now);
            this.timestampMS = now.getTime();
        }

        Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        Builder payLoadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        Builder callSid(String callSid) {
            this.callSid = callSid;
            return this;
        }

        Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        Builder direction(Constants.Direction direction) {
            this.direction = direction;
            return this;
        }

        Builder qualityParam(String qualityParam) {
            this.qualityParam = qualityParam;
            return this;
        }

        Builder qualityThreshold(int qualityThreshold) {
            this.qualityThreshold = qualityThreshold;
            return this;
        }

        Builder sampleList(List<RTCStatsSample> sampleList) {
            this.sampleList = sampleList;
            return this;
        }

        Builder sampleValue(int sampleValue) {
            this.sampleValue = sampleValue;
            return this;
        }

        Builder tempCallSid(String tempCallSid) {
            this.tempCallSid = tempCallSid;
            return this;
        }

        Builder score(Call.Score score) {
            if (score != null) {
                this.qualityScore = score.getValue();
            }
            return this;
        }

        Builder issue(Call.Issue issue) {
            if (issue != null) {
                this.issue = issue.toString();
            }
            return this;
        }

        Builder errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        Builder selectedRegion(String selectedRegion) {
            this.selectedRegion = selectedRegion;
            return this;
        }

        Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        Builder region(String region) {
            this.region = region;
            return this;
        }

        EventPayload build() {
            if (this.productName == null) {
                throw new NullPointerException("productName must not be null");
            }
            if (this.payloadType == null) {
                throw new NullPointerException("payloadType must not be null");
            }
            return new EventPayload(this);
        }
    }

    public static enum WarningName {
        WARN_HIGH_JITTER("high-jitter"),
        WARN_HIGH_PACKET_LOSS("high-packet-loss"),
        WARN_HIGH_RTT("high-rtt"),
        WARN_LOW_MOS("low-mos"),
        WARN_CONSTANT_AUDIO_IN_LEVEL("constant-audio-input-level"),
        WARN_CONSTANT_AUDIO_OUT_LEVEL("constant-audio-output-level");

        private final String warningName;

        private WarningName(String warningName) {
            this.warningName = warningName;
        }

        public String toString() {
            return this.warningName;
        }
    }
}

