/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.os.AsyncTask;
import android.os.Handler;
import android.util.Log;
import com.twilio.voice.Constants;
import com.twilio.voice.Event;
import com.twilio.voice.Logger;
import com.twilio.voice.MetricEvent;
import com.twilio.voice.Utils;
import com.twilio.voice.VoiceException;
import com.twilio.voice.VoiceURLConnection;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

class EventPublisher {
    private static final Logger logger = Logger.getLogger(EventPublisher.class);
    private static final String TAG = EventPublisher.class.getSimpleName();
    private Map<EventPublisherListener, Handler> listenerMap = new HashMap<EventPublisherListener, Handler>();
    private String accessToken;
    private String publisherName;
    private String twilioProdSdkMetricsGatewayURL;
    private String twilioProdSdkEventGatewayURL;
    int result = 0;

    EventPublisher(String publisherName, String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken must not be null.");
        }
        if (publisherName == null) {
            throw new NullPointerException("publisherName must not be null.");
        }
        this.accessToken = accessToken;
        this.publisherName = publisherName;
        this.twilioProdSdkMetricsGatewayURL = Constants.getKeyKibanaMetricsHostUrl();
        this.twilioProdSdkEventGatewayURL = Constants.getKeyKibanaEventGatewayHostUrl();
    }

    void addListener(EventPublisherListener listener) {
        Handler handler = Utils.createHandler();
        this.listenerMap.put(listener, handler);
    }

    void removeListener(EventPublisherListener listener) {
        this.listenerMap.remove(listener);
    }

    void publishMetrics(String group, String name, JSONArray payload) throws Exception {
        MetricEvent event = new MetricEvent.Builder().productName(this.publisherName).eventName(name).groupName(group).level(Constants.SeverityLevel.INFO).payLoadType("application/json").payLoad(payload).build();
        if (event != null) {
            JSONObject eventData = event.toJSONObject();
            this.publish(eventData.toString(), this.twilioProdSdkMetricsGatewayURL);
        }
    }

    void publish(Constants.SeverityLevel level, String group, String name, JSONObject payload) throws Exception {
        Event event = new Event.Builder().productName(this.publisherName).eventName(name).groupName(group).level(level).payLoadType("application/json").payLoad(payload).build();
        JSONObject eventData = event.toJSONObject();
        this.publish(eventData.toString(), this.twilioProdSdkEventGatewayURL);
    }

    private void publish(final String eventData, final String hostURL) {
        AsyncTask<Void, Void, Void> pushMetrics = new AsyncTask<Void, Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... voids) {
                HttpsURLConnection urlConnection;
                block6: {
                    logger.d("Start publishing events to : " + hostURL + "\n" + eventData);
                    urlConnection = null;
                    try {
                        String line;
                        urlConnection = VoiceURLConnection.create(EventPublisher.this.accessToken, hostURL, "POST");
                        OutputStreamWriter wr = new OutputStreamWriter(urlConnection.getOutputStream());
                        wr.write(eventData);
                        wr.close();
                        EventPublisher.this.result = urlConnection.getResponseCode();
                        String responseMessage = urlConnection.getResponseMessage();
                        if (EventPublisher.this.result == 200) {
                            logger.d("Response: " + EventPublisher.this.result + " - " + responseMessage);
                            break block6;
                        }
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                        StringBuilder stringBuilder = new StringBuilder();
                        while ((line = bufferedReader.readLine()) != null) {
                            stringBuilder.append(line);
                            stringBuilder.append('\n');
                        }
                        bufferedReader.close();
                        String jsonString = stringBuilder.toString();
                        String explanation = EventPublisher.this.result + " - " + responseMessage + "-" + jsonString;
                        logger.d("Response: " + explanation);
                        EventPublisher.this.notifyListeners(EventPublisher.this.result, responseMessage, explanation);
                    }
                    catch (Exception e) {
                        try {
                            Log.e((String)TAG, (String)(" " + e.toString()));
                            logger.e(e.toString());
                        }
                        catch (Throwable throwable) {
                            VoiceURLConnection.release(urlConnection);
                            throw throwable;
                        }
                        VoiceURLConnection.release(urlConnection);
                    }
                }
                VoiceURLConnection.release(urlConnection);
                return null;
            }
        };
        pushMetrics.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private void notifyListeners(final int errorCode, final String errorMessage, final String explanation) {
        for (Map.Entry<EventPublisherListener, Handler> entry : this.listenerMap.entrySet()) {
            final EventPublisherListener listener = entry.getKey();
            Handler handler = entry.getValue();
            if (handler == null) continue;
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        listener.onError(new VoiceException(errorCode, errorMessage, explanation){});
                    }
                }
            });
        }
    }

    static interface EventPublisherListener {
        public void onError(VoiceException var1);
    }
}

