/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.os.AsyncTask;
import com.twilio.voice.Constants;
import com.twilio.voice.EventPayload;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.RegistrarListener;
import com.twilio.voice.SidUtil;
import com.twilio.voice.VoiceURLConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

class HttpsRegistrar {
    private static final String REGISTRATION_ID_LOCATION = "Location";
    private static final String UNAUTHORIZED_JSON_MESSAGE_KEY = "message";
    private static final String UNAUTHORIZED_JSON_CODE_KEY = "code";

    private HttpsRegistrar() {
    }

    public static void register(String accessToken, String jsonPayloadString, String hostURL, RegistrarListener registrarListener) {
        HttpsRegistrar.register(accessToken, jsonPayloadString, hostURL, false, registrarListener);
    }

    public static void register(final String accessToken, final String jsonPayloadString, final String hostURL, final boolean isUnregistrationRequest, final RegistrarListener registrarListener) {
        AsyncTask<Void, Void, Void> request = new AsyncTask<Void, Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... voids) {
                HttpsURLConnection urlConnection;
                block9: {
                    urlConnection = null;
                    try {
                        urlConnection = VoiceURLConnection.create(accessToken, hostURL, "POST");
                        String requestId = SidUtil.generateGUID("RQ", accessToken);
                        urlConnection.addRequestProperty("X-Twilio-Request-Id", requestId);
                        OutputStreamWriter wr = new OutputStreamWriter(urlConnection.getOutputStream());
                        wr.write(jsonPayloadString);
                        wr.close();
                        int result = urlConnection.getResponseCode();
                        String responseMessage = urlConnection.getResponseMessage();
                        if (result == 201) {
                            String registrationLocation = urlConnection.getHeaderField(HttpsRegistrar.REGISTRATION_ID_LOCATION);
                            if (registrationLocation != null) {
                                if (!isUnregistrationRequest) {
                                    HttpsRegistrar.publishRegistrationSuccessfulEvent(accessToken, requestId, "registration");
                                }
                                registrarListener.onSuccess(registrationLocation);
                            } else {
                                HttpsRegistrar.publishError(isUnregistrationRequest, accessToken, requestId, result, responseMessage);
                                registrarListener.onError(31301, "Registration Location is null");
                            }
                            break block9;
                        }
                        if (result == 401) {
                            JSONObject jsonObject = HttpsRegistrar.processJSONError(urlConnection.getErrorStream());
                            int code = jsonObject.getInt(HttpsRegistrar.UNAUTHORIZED_JSON_CODE_KEY);
                            String message = jsonObject.getString(HttpsRegistrar.UNAUTHORIZED_JSON_MESSAGE_KEY);
                            HttpsRegistrar.publishError(isUnregistrationRequest, accessToken, requestId, result, responseMessage);
                            registrarListener.onError(code, message);
                            break block9;
                        }
                        HttpsRegistrar.publishError(isUnregistrationRequest, accessToken, requestId, result, responseMessage);
                        registrarListener.onError(31301, "Http status: " + String.valueOf(result) + " Http response message: " + responseMessage);
                    }
                    catch (Exception e) {
                        try {
                            HttpsRegistrar.handleException(e, urlConnection, registrarListener);
                        }
                        catch (Throwable throwable) {
                            VoiceURLConnection.release(urlConnection);
                            throw throwable;
                        }
                        VoiceURLConnection.release(urlConnection);
                    }
                }
                VoiceURLConnection.release(urlConnection);
                return null;
            }
        };
        request.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public static void unregister(final String accessToken, final String hostURL, final RegistrarListener registrarListener) {
        AsyncTask<Void, Void, Void> request = new AsyncTask<Void, Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... voids) {
                HttpsURLConnection urlConnection;
                block6: {
                    urlConnection = null;
                    try {
                        urlConnection = VoiceURLConnection.create(accessToken, hostURL, "DELETE");
                        String requestId = SidUtil.generateGUID("RQ", accessToken);
                        urlConnection.addRequestProperty("X-Twilio-Request-Id", requestId);
                        urlConnection.connect();
                        int result = urlConnection.getResponseCode();
                        String responseMessage = urlConnection.getResponseMessage();
                        if (result == 200 || result == 204) {
                            HttpsRegistrar.publishRegistrationSuccessfulEvent(accessToken, requestId, "unregistration");
                            registrarListener.onSuccess(null);
                            break block6;
                        }
                        if (result == 401) {
                            JSONObject jsonObject = HttpsRegistrar.processJSONError(urlConnection.getErrorStream());
                            int code = jsonObject.getInt(HttpsRegistrar.UNAUTHORIZED_JSON_CODE_KEY);
                            String message = jsonObject.getString(HttpsRegistrar.UNAUTHORIZED_JSON_MESSAGE_KEY);
                            HttpsRegistrar.publishRegistrationErrorEvent(accessToken, requestId, "unregistration-error", result, responseMessage);
                            registrarListener.onError(code, message);
                            break block6;
                        }
                        HttpsRegistrar.publishRegistrationErrorEvent(accessToken, requestId, "unregistration-error", result, responseMessage);
                        registrarListener.onError(31301, "Http status: " + String.valueOf(result) + " Http response message: " + responseMessage);
                    }
                    catch (Exception e) {
                        try {
                            HttpsRegistrar.handleException(e, urlConnection, registrarListener);
                        }
                        catch (Throwable throwable) {
                            VoiceURLConnection.release(urlConnection);
                            throw throwable;
                        }
                        VoiceURLConnection.release(urlConnection);
                    }
                }
                VoiceURLConnection.release(urlConnection);
                return null;
            }
        };
        request.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private static void handleException(Exception e, HttpsURLConnection urlConnection, RegistrarListener registrarListener) {
        if (urlConnection != null) {
            try {
                JSONObject jsonObject = HttpsRegistrar.processJSONError(urlConnection.getErrorStream());
                int code = jsonObject.getInt(UNAUTHORIZED_JSON_CODE_KEY);
                String message = jsonObject.getString(UNAUTHORIZED_JSON_MESSAGE_KEY);
                registrarListener.onError(code, message);
            }
            catch (Exception e1) {
                registrarListener.onError(31301, e.getMessage());
            }
        } else {
            registrarListener.onError(31301, e.getMessage());
        }
    }

    private static JSONObject processJSONError(InputStream errorStream) throws IOException, JSONException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(errorStream));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append('\n');
        }
        bufferedReader.close();
        return new JSONObject(stringBuilder.toString());
    }

    private static void publishError(boolean isUnregistrationRequest, String accessToken, String requestId, int errorCode, String errorMessage) {
        if (!isUnregistrationRequest) {
            HttpsRegistrar.publishRegistrationErrorEvent(accessToken, requestId, "registration-error", errorCode, errorMessage);
        } else {
            HttpsRegistrar.publishRegistrationErrorEvent(accessToken, requestId, "unregistration-registration-error", errorCode, errorMessage);
        }
    }

    private static void publishRegistrationErrorEvent(String accessToken, String requestId, String eventName, int errorCode, String errorMessage) {
        EventPublisher publisher = new EventPublisher("twilio-voice-android", accessToken);
        EventPayload eventPayload = new EventPayload.Builder().productName("twilio-voice-android").requestId(requestId).errorCode(errorCode).errorMessage(errorMessage).payLoadType("application/json").build();
        try {
            JSONObject registrationEventPayload = eventPayload.getPayload();
            publisher.publish(Constants.SeverityLevel.ERROR, "registration", eventName, registrationEventPayload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void publishRegistrationSuccessfulEvent(String accessToken, String requestId, String eventName) {
        EventPublisher publisher = new EventPublisher("twilio-voice-android", accessToken);
        EventPayload eventPayload = new EventPayload.Builder().productName("twilio-voice-android").requestId(requestId).payLoadType("application/json").build();
        try {
            JSONObject registrationEventPayload = eventPayload.getPayload();
            publisher.publish(Constants.SeverityLevel.INFO, "registration", eventName, registrationEventPayload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

