/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.twilio.voice.AudioOptions;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.Logger;
import com.twilio.voice.Preconditions;
import com.twilio.voice.Voice;
import java.util.HashSet;
import java.util.Set;

class MediaFactory {
    private static final String RELEASE_MESSAGE_TEMPLATE = "MediaFactory released %s unavailable";
    private static final Logger logger = Logger.getLogger(MediaFactory.class);
    private static volatile MediaFactory instance;
    private static volatile Set<Object> mediaFactoryOwners;
    private long nativeMediaFactoryHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MediaFactory instance(@NonNull Object owner, @NonNull Context context) {
        Preconditions.checkNotNull(owner, "owner must not be null");
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkApplicationContext(context);
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            if (instance == null) {
                Voice.loadLibrary(context);
                long nativeMediaFactoryHandle = MediaFactory.nativeCreate(context);
                if (nativeMediaFactoryHandle == 0L) {
                    logger.e("Failed to instance MediaFactory");
                } else {
                    instance = new MediaFactory(nativeMediaFactoryHandle);
                }
            }
            mediaFactoryOwners.add(owner);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    @Nullable
    synchronized LocalAudioTrack createAudioTrack(Context context, boolean enabled, @Nullable AudioOptions audioOptions, String name) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkApplicationContext(context, "must create local audio track with application context");
        Preconditions.checkState(this.nativeMediaFactoryHandle != 0L, RELEASE_MESSAGE_TEMPLATE, (Object)"createAudioTrack");
        return this.nativeCreateAudioTrack(this.nativeMediaFactoryHandle, context, enabled, audioOptions, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void release(Object owner) {
        if (instance == null) return;
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            mediaFactoryOwners.remove(owner);
            if (instance == null || !mediaFactoryOwners.isEmpty()) return;
            this.nativeRelease(this.nativeMediaFactoryHandle);
            this.nativeMediaFactoryHandle = 0L;
            instance = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    long getNativeMediaFactoryHandle() {
        return this.nativeMediaFactoryHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    static boolean isReleased() {
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=5)
    static void manualRelease() {
        Class<MediaFactory> clazz = MediaFactory.class;
        synchronized (MediaFactory.class) {
            if (instance != null) {
                mediaFactoryOwners.clear();
                Object o = new Object();
                instance.release(o);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private MediaFactory(long nativeMediaFactoryHandle) {
        this.nativeMediaFactoryHandle = nativeMediaFactoryHandle;
    }

    private static native long nativeCreate(Context var0);

    private native LocalAudioTrack nativeCreateAudioTrack(long var1, Context var3, boolean var4, AudioOptions var5, String var6);

    private native void nativeRelease(long var1);

    @VisibleForTesting(otherwise=5)
    private native void nativeTestRelease(long var1);

    static {
        mediaFactoryOwners = new HashSet<Object>();
    }
}

