/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import com.twilio.voice.EventPayload;
import com.twilio.voice.MonitorThresholds;
import com.twilio.voice.Preconditions;
import com.twilio.voice.RTCStatsSample;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class RTCMonitor {
    private static final int WARNING_TIMEOUT_IN_MILLISECONDS = 5000;
    private RTCStatsSample currentSample = null;
    private ArrayList<RTCStatsSample> recentSamples = new ArrayList();
    private Map<EventPayload.WarningName, HashMap<String, Object>> warnings = new HashMap<EventPayload.WarningName, HashMap<String, Object>>();
    private Map<EventPayload.WarningName, Date> activeWarnings = new HashMap<EventPayload.WarningName, Date>();
    private int constantAudioInputLevelSampleCounter;
    private int constantAudioOutputLevelSampleCounter;
    private int previousAudioInputLevel;
    private int previousAudioOutputLevel;
    private RTCStatsSample previousSample;
    static int SAMPLE_COUNT_METRICS = 5;
    static final int SAMPLE_COUNT_TO_RAISE_WARNING = 3;
    static MonitorThresholds thresholds = new MonitorThresholds.Builder().jitterThreshold(30).mosScoreThreshhold(3).packetsLostFraction(1).rttThreshold(400).audioConstantInputLevelSampleCounter(10).audioConstantOutputLevelSampleCounter(10).build();
    private List<Listener> listenerList = new ArrayList<Listener>();

    RTCMonitor() {
    }

    RTCMonitor(MonitorThresholds thresholds) {
        Preconditions.checkNotNull(thresholds, "thresholds must not be null");
        RTCMonitor.thresholds = thresholds;
    }

    void addListener(Listener listener) {
        this.listenerList.add(listener);
    }

    Map<EventPayload.WarningName, HashMap<String, Object>> monitor(RTCStatsSample currentSample) {
        this.recentSamples.add(currentSample);
        this.setCurrentSample(currentSample);
        if (this.recentSamples.size() > SAMPLE_COUNT_METRICS) {
            ArrayList<RTCStatsSample> al2 = new ArrayList<RTCStatsSample>(this.recentSamples.subList(1, SAMPLE_COUNT_METRICS + 1));
            this.recentSamples = al2;
        }
        if (thresholds.getMaxDurationConstantAudioInputLevel() > -1) {
            this.checkAudioLevel(currentSample.getAudioInputLevel(), this.previousAudioInputLevel, thresholds.getMaxDurationConstantAudioInputLevel(), EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL);
        }
        if (thresholds.getMaxDurationConstantAudioOutputLevel() > -1) {
            this.checkAudioLevel(currentSample.getAudioOutputLevel(), this.previousAudioOutputLevel, thresholds.getMaxDurationConstantAudioOutputLevel(), EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL);
        }
        if (thresholds.getMinMosScoreThreshhold() > -1) {
            this.checkAudioQuality("mos", thresholds.getMinMosScoreThreshhold(), ComparisonType.MIN);
        }
        if (thresholds.getMaxJitterThreshold() > -1) {
            this.checkAudioQuality("jitter", thresholds.getMaxJitterThreshold(), ComparisonType.MAX);
        }
        if (thresholds.getMaxRttThreshold() > -1) {
            this.checkAudioQuality("rtt", thresholds.getMaxRttThreshold(), ComparisonType.MAX);
        }
        if (thresholds.getMaxPacketsLostFraction() > -1) {
            this.checkAudioQuality("packetsLostFraction", thresholds.getMaxPacketsLostFraction(), ComparisonType.MAX);
        }
        this.previousSample = this.currentSample;
        return this.warnings;
    }

    private void checkAudioLevel(int currentLevel, int previousLevel, int threshold, EventPayload.WarningName warningName) {
        if (warningName == EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL) {
            int n = this.constantAudioInputLevelSampleCounter = currentLevel == previousLevel ? this.constantAudioInputLevelSampleCounter + 1 : 0;
            if (this.constantAudioInputLevelSampleCounter == threshold) {
                this.constantAudioInputLevelSampleCounter = 0;
                this.raiseWarningWithValue(EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL, "audioInputConstantMaxDuration", thresholds.getMaxDurationConstantAudioInputLevel(), currentLevel);
            } else if (this.constantAudioInputLevelSampleCounter == 0) {
                this.clearWarning(EventPayload.WarningName.WARN_CONSTANT_AUDIO_IN_LEVEL);
            }
            this.previousAudioInputLevel = currentLevel;
        } else if (warningName == EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL) {
            int n = this.constantAudioOutputLevelSampleCounter = currentLevel == previousLevel ? this.constantAudioOutputLevelSampleCounter + 1 : 0;
            if (this.constantAudioOutputLevelSampleCounter == threshold) {
                this.constantAudioOutputLevelSampleCounter = 0;
                this.raiseWarningWithValue(EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL, "audioOutputConstantMaxDuration", thresholds.getMaxDurationConstantAudioOutputLevel(), currentLevel);
            } else if (this.constantAudioOutputLevelSampleCounter == 0) {
                this.clearWarning(EventPayload.WarningName.WARN_CONSTANT_AUDIO_OUT_LEVEL);
            }
            this.previousAudioOutputLevel = currentLevel;
        }
    }

    private void checkAudioQuality(String name, int threshold, ComparisonType type) {
        int counter = 0;
        if (type == ComparisonType.MAX) {
            counter = RTCMonitor.countHigh(name, threshold, this.recentSamples);
        } else if (type == ComparisonType.MIN) {
            counter = RTCMonitor.countLow(name, threshold, this.recentSamples);
        }
        if (counter >= 3) {
            if (name.equals("jitter")) {
                this.raiseWarningWithSamples(EventPayload.WarningName.WARN_HIGH_JITTER, "jitter", thresholds.getMaxJitterThreshold());
            } else if (name.equals("rtt")) {
                this.raiseWarningWithSamples(EventPayload.WarningName.WARN_HIGH_RTT, "rtt", thresholds.getMaxRttThreshold());
            } else if (name.endsWith("packetsLostFraction")) {
                this.raiseWarningWithSamples(EventPayload.WarningName.WARN_HIGH_PACKET_LOSS, "packetsLostFraction", thresholds.getMaxPacketsLostFraction());
            } else if (name.equals("mos")) {
                this.raiseWarningWithSamples(EventPayload.WarningName.WARN_LOW_MOS, "mos", thresholds.getMinMosScoreThreshhold());
            }
        } else if (counter == 0) {
            if (name.equals("jitter")) {
                this.clearWarning(EventPayload.WarningName.WARN_HIGH_JITTER);
            } else if (name.equals("rtt")) {
                this.clearWarning(EventPayload.WarningName.WARN_HIGH_RTT);
            } else if (name.equals("packetsLostFraction")) {
                this.clearWarning(EventPayload.WarningName.WARN_HIGH_PACKET_LOSS);
            } else if (name.equals("mos")) {
                this.clearWarning(EventPayload.WarningName.WARN_LOW_MOS);
            }
        }
    }

    private void setCurrentSample(RTCStatsSample sample) {
        this.currentSample = sample;
        if (this.listenerList != null) {
            for (Listener listener : this.listenerList) {
                if (listener == null) continue;
                listener.onSample(sample);
            }
        }
    }

    private void raiseWarningWithSamples(EventPayload.WarningName nameOfTheWarning, String warningParam, int threshold) {
        this.activeWarnings.put(nameOfTheWarning, new Date());
        HashMap<String, Object> warningDetails = new HashMap<String, Object>();
        warningDetails.put("WarningName", (Object)nameOfTheWarning);
        warningDetails.put("WarningParam", warningParam);
        warningDetails.put("threshold", threshold);
        warningDetails.put("RecentSamples", this.recentSamples);
        this.warnings.put(nameOfTheWarning, warningDetails);
    }

    private void raiseWarningWithValue(EventPayload.WarningName nameOfTheWarning, String warningParam, int threshold, int value) {
        Date timeOfWarning = this.activeWarnings.get((Object)nameOfTheWarning);
        if (timeOfWarning != null && new Date().getTime() - timeOfWarning.getTime() < 5000L) {
            return;
        }
        this.activeWarnings.put(nameOfTheWarning, new Date());
        HashMap<String, Object> warningDetails = new HashMap<String, Object>();
        warningDetails.put("WarningName", (Object)nameOfTheWarning);
        warningDetails.put("WarningParam", warningParam);
        warningDetails.put("threshold", threshold);
        warningDetails.put("RecentSampleValue", value);
        this.warnings.put(nameOfTheWarning, warningDetails);
    }

    private void clearWarning(EventPayload.WarningName nameOfTheWarning) {
        Date timeOfWarning = this.activeWarnings.get((Object)nameOfTheWarning);
        if (timeOfWarning == null) {
            return;
        }
        this.activeWarnings.remove((Object)nameOfTheWarning);
        HashMap<String, EventPayload.WarningName> warningDetails = new HashMap<String, EventPayload.WarningName>();
        warningDetails.put("ClearWarning", nameOfTheWarning);
        this.warnings.put(nameOfTheWarning, warningDetails);
    }

    static int countLow(String name, int threshold, ArrayList<RTCStatsSample> samples) {
        int lowCount = 0;
        int sampleValue = 0;
        for (RTCStatsSample sample : samples) {
            if (name.compareTo("mos") == 0) {
                sampleValue = (int)sample.getMosScore();
            } else if (name.compareTo("jitter") == 0) {
                sampleValue = sample.getJitter();
            } else if (name.compareTo("rtt") == 0) {
                sampleValue = sample.getRtt();
            } else if (name.compareTo("packetsLostFraction") == 0) {
                sampleValue = (int)sample.getFractionLost();
            }
            lowCount += sampleValue < threshold ? 1 : 0;
        }
        return lowCount;
    }

    static int countHigh(String name, int threshold, ArrayList<RTCStatsSample> samples) {
        int highCount = 0;
        int sampleValue = 0;
        for (RTCStatsSample sample : samples) {
            if (name.compareTo("mos") == 0) {
                sampleValue = (int)sample.getMosScore();
            } else if (name.compareTo("jitter") == 0) {
                sampleValue = sample.getJitter();
            } else if (name.compareTo("rtt") == 0) {
                sampleValue = sample.getRtt();
            } else if (name.compareTo("packetsLostFraction") == 0) {
                sampleValue = (int)sample.getFractionLost();
            }
            highCount += sampleValue > threshold ? 1 : 0;
        }
        return highCount;
    }

    static interface Listener {
        public void onSample(RTCStatsSample var1);
    }

    static enum ComparisonType {
        MIN,
        MAX,
        MAXCONSTANTDURATION;

    }
}

