/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import com.twilio.voice.Constants;
import com.twilio.voice.Logger;
import org.json.JSONObject;

class RTCStatsSample {
    private static final Logger logger = Logger.getLogger(RTCStatsSample.class);
    String timeStamp;
    long timestampMS;
    double mos;
    double fractionLost;
    long packetsReceived;
    long packetsLost;
    long packetsSent;
    long totalPacketsReceived;
    long totalPacketsSent;
    long totalPacketsLost;
    long totalBytesReceived;
    long totalBytesSent;
    int jitter;
    int rtt;
    int audioInputLevel;
    int audioOutputLevel;
    String callSid;
    String codec;
    Constants.Direction direction;

    public long getPacketsReceived() {
        return this.packetsReceived;
    }

    public long getPacketsLost() {
        return this.packetsLost;
    }

    public long getPacketsSent() {
        return this.packetsSent;
    }

    public long getTotalPacketsReceived() {
        return this.totalPacketsReceived;
    }

    public long getTotalPacketsSent() {
        return this.totalPacketsSent;
    }

    public long getTotalPacketsLost() {
        return this.totalPacketsLost;
    }

    public long getTotalBytesReceived() {
        return this.totalBytesReceived;
    }

    public long getTotalBytesSent() {
        return this.totalBytesSent;
    }

    public int getJitter() {
        return this.jitter;
    }

    public int getRtt() {
        return this.rtt;
    }

    public int getAudioInputLevel() {
        return this.audioInputLevel == -1 ? -1 : this.audioInputLevel * 128;
    }

    public int getAudioOutputLevel() {
        return this.audioOutputLevel == -1 ? -1 : this.audioOutputLevel * 128;
    }

    public String getCodec() {
        return this.codec;
    }

    public double getFractionLost() {
        return this.fractionLost;
    }

    public String getCallSid() {
        return this.callSid;
    }

    public double getMos() {
        return this.mos;
    }

    public void setCallSid(String callSid) {
        this.callSid = callSid;
    }

    public void setDirection(Constants.Direction direction) {
        this.direction = direction;
    }

    public String getTimestamp() {
        return this.timeStamp;
    }

    public JSONObject toJson() {
        try {
            JSONObject eventJSON = new JSONObject();
            eventJSON.put("timestamp", (Object)this.getTimestamp());
            eventJSON.put("timestamp_ms", this.getTimestampMillis());
            eventJSON.put("call_sid", (Object)this.getCallSid());
            eventJSON.put("sdk_version", (Object)"3.0.0-beta11");
            eventJSON.put("packets_received", this.getPacketsReceived());
            eventJSON.put("total_packets_lost", this.getTotalPacketsLost());
            eventJSON.put("packets_lost_fraction", this.getFractionLost());
            eventJSON.put("total_packets_sent", this.getTotalPacketsSent());
            eventJSON.put("total_packets_received", this.getTotalPacketsReceived());
            eventJSON.put("total_bytes_received", this.getTotalBytesReceived());
            eventJSON.put("total_bytes_sent", this.getTotalBytesSent());
            eventJSON.put("jitter", this.getJitter());
            eventJSON.put("rtt", this.getRtt());
            eventJSON.put("audio_level_in", this.getAudioInputLevel());
            eventJSON.put("audio_level_out", this.getAudioOutputLevel());
            eventJSON.put("mos", this.getMos());
            eventJSON.put("audio_codec", (Object)this.getCodec());
            eventJSON.put("direction", (Object)this.direction);
            logger.v(eventJSON.toString());
            return eventJSON;
        }
        catch (Exception e) {
            logger.e(e.toString());
            return null;
        }
    }

    public String toString() {
        return "StatsExtended [timestamp=" + this.timeStamp + ", packetsReceived=" + this.packetsReceived + ", packetsLost=" + this.packetsLost + ", packetsSent=" + this.packetsSent + ", bytesReceived=" + this.totalBytesReceived + ", bytesSent=" + this.totalBytesSent + ", jitter=" + this.jitter + ", rtt=" + this.rtt + ", audioInputLevel=" + this.audioInputLevel + ", audioOutputLevel=" + this.audioOutputLevel + "]";
    }

    public long getTimestampMillis() {
        return this.timestampMS;
    }

    public double getMosScore() {
        return this.mos;
    }
}

