/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.os.Handler;
import com.twilio.voice.Constants;
import com.twilio.voice.HttpsRegistrar;
import com.twilio.voice.RegistrarListener;
import com.twilio.voice.Registration;
import com.twilio.voice.RegistrationException;
import com.twilio.voice.RegistrationListener;
import com.twilio.voice.UnregistrationListener;
import com.twilio.voice.Utils;

class Registrar
implements RegistrarListener {
    private static final String RELATIVE_REGISTER_URL = "/v1/registrations?productId=voice";
    private static final String RELATIVE_UNREGISTER_URL = "?productId=voice";
    private final Handler handler;
    private final String accessToken;
    private final String channelType;
    private final String notificationToken;
    private RegistrationListener registrationListener;
    private UnregistrationListener unregistrationListener;

    public Registrar(String accessToken, String channelType, String notificationToken) {
        this.accessToken = accessToken;
        this.channelType = channelType;
        this.notificationToken = notificationToken;
        this.handler = Utils.createHandler();
    }

    public void register(RegistrationListener listener) {
        this.registrationListener = listener;
        String jsonPayloadString = new Registration(this.channelType, this.notificationToken).toJson().toString();
        String urlString = Constants.getNotificationServiceUrl() + RELATIVE_REGISTER_URL;
        HttpsRegistrar.register(this.accessToken, jsonPayloadString, urlString, this);
    }

    public void unregister(UnregistrationListener listener) {
        this.unregistrationListener = listener;
        String jsonPayloadString = new Registration(this.channelType, this.notificationToken).toJson().toString();
        String urlString = Constants.getNotificationServiceUrl() + RELATIVE_REGISTER_URL;
        boolean isUnregistrationRequest = true;
        HttpsRegistrar.register(this.accessToken, jsonPayloadString, urlString, isUnregistrationRequest, new RegistrarListener(){

            @Override
            public void onSuccess(String registrationLocation) {
                String urlString = registrationLocation + Registrar.RELATIVE_UNREGISTER_URL;
                HttpsRegistrar.unregister(Registrar.this.accessToken, urlString, Registrar.this);
            }

            @Override
            public void onError(int errorCode, String errorMessage) {
                Registrar.this.onError(errorCode, errorMessage);
            }
        });
    }

    @Override
    public void onSuccess(String registrationLocation) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (Registrar.this.registrationListener != null) {
                    Registrar.this.registrationListener.onRegistered(Registrar.this.accessToken, Registrar.this.notificationToken);
                } else {
                    Registrar.this.unregistrationListener.onUnregistered(Registrar.this.accessToken, Registrar.this.notificationToken);
                }
            }
        });
    }

    @Override
    public void onError(final int errorCode, final String errorMessage) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (Registrar.this.registrationListener != null) {
                    RegistrationException registrationException = new RegistrationException(errorCode, "Registration failed", errorMessage);
                    Registrar.this.registrationListener.onError(registrationException, Registrar.this.accessToken, Registrar.this.notificationToken);
                } else {
                    RegistrationException registrationException = new RegistrationException(errorCode, "Unregistration failed", errorMessage);
                    Registrar.this.unregistrationListener.onError(registrationException, Registrar.this.accessToken, Registrar.this.notificationToken);
                }
            }
        });
    }
}

